/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.silk.SilkResources;

public class IssueImageRule
implements ImageRule {
    private final String DESCRIPTION = "single";
    private final ImageDescriptor tick;
    private final ImageDescriptor fatal;
    private final ImageDescriptor error;
    private final ImageDescriptor warning;
    private final ImageDescriptor info;
    private final ImageDescriptor note;
    private final ImageDescriptor help;

    public IssueImageRule(ReadGraph graph) throws DatabaseException {
        SilkResources SILK = SilkResources.getInstance((ReadGraph)graph);
        this.tick = (ImageDescriptor)graph.adapt(SILK.tick, ImageDescriptor.class);
        this.fatal = (ImageDescriptor)graph.adapt(SILK.bomb, ImageDescriptor.class);
        this.error = (ImageDescriptor)graph.adapt(SILK.exclamation, ImageDescriptor.class);
        this.warning = (ImageDescriptor)graph.adapt(SILK.error, ImageDescriptor.class);
        this.info = (ImageDescriptor)graph.adapt(SILK.information, ImageDescriptor.class);
        this.note = (ImageDescriptor)graph.adapt(SILK.note, ImageDescriptor.class);
        this.help = (ImageDescriptor)graph.adapt(SILK.help, ImageDescriptor.class);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Variable issue = (Variable)content;
        String severity = (String)issue.getPossiblePropertyValue(graph, "severity");
        if (severity == null) {
            return Collections.emptyMap();
        }
        boolean resolved = this.isResolved(graph, issue);
        return Collections.singletonMap("single", resolved ? this.tick : this.toImageDescriptor(severity));
    }

    public boolean isResolved(ReadGraph graph, Variable issue) throws DatabaseException {
        Resource issueResource = issue.getPossibleRepresents(graph);
        if (issueResource != null) {
            return graph.hasStatement(issueResource, IssueResource.getInstance((ReadGraph)graph).Resolved);
        }
        Boolean resolved = (Boolean)issue.getPossiblePropertyValue(graph, "resolved");
        return Boolean.TRUE.equals(resolved);
    }

    private ImageDescriptor toImageDescriptor(String severity) {
        switch (severity) {
            case "Fatal": {
                return this.fatal;
            }
            case "Error": {
                return this.error;
            }
            case "Warning": {
                return this.warning;
            }
            case "Info": {
                return this.info;
            }
            case "Note": {
                return this.note;
            }
        }
        return this.help;
    }
}

