/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public interface IGraphModel {
	// Obstacles
	Collection<Object> getObstacles();
	Rectangle2D getObstacleShape(Object obstacle);
	
	// Connections
	Collection<Object> getConnections();
	/**
	 * Does not contain the begin and end points.
	 */
	double[] getRoutePoints(Object connection);
	Terminal getBeginTerminal(Object connection);
	Terminal getEndTerminal(Object connection);
	
	// Paths
	Path2D getPath(Object connection);
	void setPath(Object connection, Path2D path);
}
