/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public interface IConnection {
    
    public class Connector {    
        public double x, y;
        public int allowedDirections;
        public Rectangle2D parentObstacle;
        
        public Connector() {
            allowedDirections = 0xf;
        }
        
        public Connector(double x, double y, int allowedDirections,
            Rectangle2D parentObstacle) {
            this.x = x;
            this.y = y;
            this.allowedDirections = allowedDirections;
            this.parentObstacle = parentObstacle;
        }
    }    
    
    Collection<? extends Object> getSegments();
    Connector getBegin(Object seg);
    Connector getEnd(Object seg);
    
    void setPath(Object seg, Path2D path);    
    
}
