/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.notification;

import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DParentNode;

/**
 * @author Tuukka Lehtonen
 *
 * @see AbstractNotification
 * @see MessageNotification a basic notification for showing a message along
 *      with an image.
 * @see PositionedMessage
 */
public interface INotification extends Comparable<INotification> {

    long getCreationTime();

    /**
     * Update the scenegraph to properly paint this notification.
     * 
     * @param the parent node of the notification
     */
    void update(G2DParentNode parent);

    /**
     * @param r
     */
    void setBounds(Rectangle2D r);

    /**
     * @param p
     */
    void setProgress(double p);

    /**
     * Get rectangle that contains the whole notification.
     * 
     * @return bounds
     */
    //Rectangle2D getBounds(Graphics2D g);

}
