/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.layers;

/**
 * @author Antti Villberg
 */
public interface IEditableLayer extends ILayer {

    String PROP_NAME = "name";

    /**
     * 
     */
    public static class LayerChangeEvent {
        private final ILayer source;
        private final String property;
        private final Object oldValue;
        private final Object newValue;
        public LayerChangeEvent(ILayer source, String property, Object oldValue, Object newValue) {
            this.source = source;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
        public ILayer getSource() {
            return source;
        }
        public String getProperty() {
            return property;
        }
        public Object getOldValue() {
            return oldValue;
        }
        public Object getNewValue() {
            return newValue;
        }
        
    }

    /**
     * For listening to changes in a layer. For the time being the only thing
     * that can change is the name.
     */
    public interface ILayerListener {
        void layerChanged(LayerChangeEvent event);
    }

    void setName(String name);

    void addLayerListener(ILayerListener l);
    void removeLayerListener(ILayerListener l);

}
