/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Text;

/**
 * @author Toni Kalajainen
 */
public class ProxyText implements Text {

    private static final long serialVersionUID = -4459088024563476380L;

    Text orig;
    IProxyProvider provider;

    public ProxyText(IProxyProvider provider, Text orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public String getText(IElement e) {
        return orig.getText(provider.provide(e));
    }

    @Override
    public void setText(IElement e, String text) {
        orig.setText(e, text);
    }

}
