/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @See {@link TransitionFunction}
 * @author Toni Kalajainen
 */
public class TransitionFunctionPainter implements SceneGraph {
	/**
	 * 
	 */
	private static final long serialVersionUID = 218125859645762515L;
	TransitionFunction func;
	Path2D path;
	final static BasicStroke STROKE = new BasicStroke(1.0f);
	
    public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

	public TransitionFunctionPainter(TransitionFunction func) {
		this.func = func;
		path = new Path2D.Double();
		for (int i=0; i<101; i++)
		{
			double x = ((double)i)/100;
			double y = func.f(x);
			if (i==0)
				path.moveTo(x, 1-y);
			else
				path.lineTo(x, 1-y);
		}		
	}

	@Override
	public void cleanup(IElement e) {
       Node node = e.removeHint(SG_NODE);
       if (node != null)
           node.remove();
	}

	@Override
	public void init(IElement e, G2DParentNode parent) {
		ShapeNode node = (ShapeNode) e.getHint(SG_NODE);
		if (node == null) {
			node = parent.addNode(ShapeNode.class);
           	e.setHint(SG_NODE, node);
		}
		
		Rectangle2D bounds = ElementUtils.getElementBounds(e);
		
		AffineTransform transform = AffineTransform.getTranslateInstance(-bounds.getMinX(), -bounds.getMinY());
		transform.scale(bounds.getWidth(), bounds.getHeight());
		
		node.setTransform(transform);
		node.setStroke(STROKE);
		node.setScaleStroke(true);
		node.setColor(Color.BLACK);
		node.setShape(path);
	}
}
