/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.Clickable.PressStatus;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Togglable;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public abstract class ResizeableImagePaint implements SceneGraph {

	private static final long serialVersionUID = 5955540004168283683L;
	public static final Key  KEY_SG_NODE             = new SceneGraphNodeKey(Node.class, "RESIZABLE_IMAGE_SG_NODE");
	

	public ResizeableImagePaint() {

	}
	
    @Override
    public void init(final IElement e, final G2DParentNode parent) {
    	System.out.println("ResizeableImagePaint.init");
        Togglable togglable = e.getElementClass().getAtMostOneItemOfClass(Togglable.class);
        boolean	toggled = false;
        if (togglable != null)
            toggled = togglable.isChecked(e);

        Clickable.PressStatus status = null;
        Clickable clickable = e.getElementClass().getAtMostOneItemOfClass(Clickable.class);
		status = PressStatus.NORMAL;//clickable.getPressStatus(e, ctx);

		Image image = getImage(status, toggled);
		
		
		Node node = e.getHint(KEY_SG_NODE);
		if (node != null)
			node.remove();
		
		node = image.init(parent);
		e.setHint(KEY_SG_NODE, node);
		e.addHintListener(new IHintListener() {
			
			@Override
			public void hintRemoved(IHintObservable sender, Key key, Object oldValue) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void hintChanged(IHintObservable sender, Key key, Object oldValue,
					Object newValue) {
				if (key == ElementHints.KEY_TRANSFORM) {
					G2DNode node = e.getHint(KEY_SG_NODE);
					Rectangle2D size = e.getHint(ElementHints.KEY_BOUNDS);
					AffineTransform at = (AffineTransform)newValue;
					AffineTransform at2 = node.getTransform();
					node.setTransform(new AffineTransform(at2.getScaleX(),at2.getShearX(),at2.getShearY(),at2.getScaleY(),at.getTranslateX()+size.getWidth()*0.5,at.getTranslateY()+size.getHeight()*0.5));
				}
				if (key == ElementHints.KEY_BOUNDS) {
					G2DNode node = e.getHint(KEY_SG_NODE);
					Rectangle2D size = (Rectangle2D)newValue;
					Rectangle2D bounds = node.getBoundsInLocal();
					AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
					
					node.setTransform(new AffineTransform(size.getWidth()/bounds.getWidth(),0,0,size.getHeight()/bounds.getHeight(),at.getTranslateX()+size.getWidth()*0.5,at.getTranslateY()+size.getHeight()*0.5));
				}
					
				
			}
		});
		
    }

    public void cleanup(final IElement e) {
    	Node node = e.getHint(KEY_SG_NODE);
		if (node != null)
			node.remove();
	
    }

    public abstract Image getImage(Clickable.PressStatus status, boolean toggled);

}
