/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Togglable;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;


/**
 * Base implementation for button handlers
 * 
 * 
 * @author Toni Kalajainen
 */
public abstract class AbstractTogglable extends AbstractClickable implements Togglable {

	private static final long serialVersionUID = 8409636755289629134L;
	public static Key TOGGLE_KEY = new KeyOf(Boolean.class);

	public AbstractTogglable(Double strayDistance) {
		super(strayDistance);
	}

	public AbstractTogglable() {
		super();
	}


	@Override
	public boolean handleMouseEvent(IElement e, ICanvasContext ctx,
			MouseEvent me) {

		boolean b = super.handleMouseEvent(e, ctx, me);
		
		return b;
	}

	
	protected void onClicked(GrabInfo gi, ICanvasContext ctx) {
		IElement e = gi.e;
		Boolean b = e.getHint(TOGGLE_KEY);
		if (b == null)
			b = false;
		e.setHint(TOGGLE_KEY, !b);
	}
	
	@Override
	public boolean isChecked(IElement e) {
		Boolean b = e.getHint(TOGGLE_KEY);
		return (b == null ? false : b);
	}
	
}
