/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Required;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.element.handler.impl.Resizeable;

/**
 * This interface is used for handling elements internal size.
 * 
 * See default implementations:
 * 
 * @See {@link FixedSize} size is fixed
 * @See {@link Resizeable} size can be changed by user
 * 
 * @author Toni Kalajainen
 */
@Single
@Required
public interface InternalSize extends ElementHandler {

    /**
     * Return the size of the element (in element coordinates). It is possible
     * for an element to not have bounds. See return value specification for how
     * to notice this.
     * 
     * @param e element to get bounds for
     * @param size size to be written to, or null (instantiates new)
     * @return internal size of the element or the size argument as is if the
     *         specified element does not have bounds (i.e. is hidden or
     *         otherwise does not have a visual representation)
     */
    Rectangle2D getBounds(IElement e, Rectangle2D size);

}
