/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.util.Collection;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;

/**
 * A handler for retrieving the child elements of an element.
 *
 * @author Tuukka Lehtonen
 */
@Single
public interface Children extends ElementHandler {

    public static class ChildEvent {
        public final IElement             parent;
        public final Collection<IElement> removed;
        public final Collection<IElement> added;

        public ChildEvent(IElement parent, Collection<IElement> removed, Collection<IElement> added) {
            this.parent = parent;
            this.removed = removed;
            this.added = added;
        }

        @Override
        public String toString() {
            return getClass().getSimpleName() + "[parent=" + parent + ", removed=" + removed + ", added=" + added + "]";
        }
    }

    public interface ChildListener {
        void elementChildrenChanged(ChildEvent event);
    }

    /**
     * @param element the element to check for child elements
     * @param result the collection to populate with the results or
     *        <code>null</code> to allocate a new collection. The results shall
     *        be appended to the provided collection.
     * @return all child elements of the specified IElement or <code>null</code>
     *         if result was <code>null</code> and no children exist
     */
    Collection<IElement> getChildren(IElement element, Collection<IElement> result);

    /**
     * @param listener
     */
    void addChildListener(IElement element, ChildListener listener);

    /**
     * @param listener
     */
    void removeChildListener(IElement element, ChildListener listener);

}
