/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.connection;

import java.util.Collection;

import org.simantics.g2d.diagram.handler.Topology.Connection;
import org.simantics.g2d.element.IElement;

/**
 * <code>ConnectionEntity</code> is an interface for querying the contents of a
 * branched connection.
 * 
 * @author Tuukka Lehtonen
 */
public interface ConnectionEntity {

    /**
     * @return
     */
    IElement getConnection();

    /**
     * Get all branch points that are part of this connection.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<IElement> getBranchPoints(Collection<IElement> result);

    /**
     * Get all segments that are part of this connection.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<IElement> getSegments(Collection<IElement> result);

    /**
     * Get all topological terminal connections of this connection entity.
     * Terminal connections are the only way to attach a connection to an
     * element terminal.
     * 
     * @param result the collection to store the result into or
     *        <code>null</code> to allocate a new collection
     * @return the result collection
     */
    Collection<Connection> getTerminalConnections(Collection<Connection> result);

    public static class ConnectionEvent {
        public final IElement             connection;
        public final Collection<IElement> removedParts;
        public final Collection<IElement> addedParts;

        public ConnectionEvent(IElement connection, Collection<IElement> removedParts, Collection<IElement> addedParts) {
            this.connection = connection;
            this.removedParts = removedParts;
            this.addedParts = addedParts;
        }
    }

    public interface ConnectionListener {
        void connectionChanged(ConnectionEvent event);
    }

    /**
     * @param listener
     */
    void setListener(ConnectionListener listener);

}
