package org.simantics.document.server.io;

import java.io.File;
import java.io.IOException;
import java.util.List;

public interface IRequest {
	public String getParameter(String name);
	public String getHeader(String name);
	public List<String> getHeaders(String name);
	public String getCookie(String name);
	public String getMethod();
	public String getPathInfo();
	public String getContextPath();
	public String getRemoteAddress();
	public String getRemoteHost();
	public int getRemotePort();
	public String getContentType();
	public long getContentLength();
	public String getCharacterEncoding();
	public long readToFile(File file) throws IOException;
	// TODO: input reading
	//public InputStream getInputStream();
	boolean isSecure();
	String getMultiPartBodyAsString(String name) throws IOException;
	File getMultiPartBodyAsTempFile(String name) throws IOException;
	void close();
}
