/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.symbolcontribution.AbstractSymbolProvider;
import org.simantics.diagram.symbolcontribution.CompositeSymbolGroup;
import org.simantics.diagram.symbolcontribution.IIdentifiedObject;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.strings.EString;

public class CompositeSymbolProviderFactory
implements SymbolProviderFactory {
    Collection<SymbolProviderFactory> factories;

    public CompositeSymbolProviderFactory(Collection<SymbolProviderFactory> factories) {
        if (factories == null) {
            throw new NullPointerException("null factories");
        }
        this.factories = factories;
    }

    public int hashCode() {
        return this.factories.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeSymbolProviderFactory other = (CompositeSymbolProviderFactory)obj;
        return this.factories.equals(other.factories);
    }

    @Override
    public ISymbolProvider create(ReadGraph graph) throws DatabaseException {
        ArrayList<ISymbolProvider> providers = new ArrayList<ISymbolProvider>(this.factories.size());
        for (SymbolProviderFactory factory : this.factories) {
            ISymbolProvider provider = factory.create(graph);
            providers.add(provider);
        }
        return new CompositeSymbolProvider(providers);
    }

    static class CompositeSymbolProvider
    extends AbstractSymbolProvider {
        Collection<ISymbolProvider> providers;

        public CompositeSymbolProvider(Collection<ISymbolProvider> providers) {
            this.providers = providers;
        }

        @Override
        public Collection<ISymbolGroup> getSymbolGroups() {
            MapList groupsByName = new MapList();
            HashSet<Object> processedIds = new HashSet<Object>();
            TreeMap<String, ISymbolGroup> groups = new TreeMap<String, ISymbolGroup>();
            for (ISymbolProvider provider : this.providers) {
                for (ISymbolGroup group : provider.getSymbolGroups()) {
                    Object id;
                    String name = group.getName();
                    if (group instanceof IIdentifiedObject && !processedIds.add(id = ((IIdentifiedObject)((Object)group)).getId())) continue;
                    groupsByName.add((Object)name, (Object)group);
                }
            }
            for (String name : groupsByName.getKeys()) {
                List grps = groupsByName.getValues((Object)name);
                int grpCount = grps.size();
                if (grpCount == 1) {
                    groups.put(name, (ISymbolGroup)grps.get(0));
                    continue;
                }
                if (grpCount <= 1) continue;
                Object id = this.combineIdentification(grps);
                String description = this.combineDescriptions(grps);
                CompositeSymbolGroup cgroup = new CompositeSymbolGroup(id, name, description);
                for (ISymbolGroup grp : grps) {
                    cgroup.add(grp);
                }
                groups.put(name, cgroup);
            }
            return new ArrayList<ISymbolGroup>(groups.values());
        }

        private Object combineIdentification(List<ISymbolGroup> grps) {
            HashSet<Object> id = new HashSet<Object>();
            for (ISymbolGroup grp : grps) {
                if (!(grp instanceof IIdentifiedObject)) continue;
                id.add(((IIdentifiedObject)((Object)grp)).getId());
            }
            return id;
        }

        private String combineDescriptions(List<ISymbolGroup> grps) {
            TreeSet<String> descs = new TreeSet<String>();
            for (ISymbolGroup grp : grps) {
                descs.add(grp.getDescription());
            }
            if (descs.isEmpty()) {
                return "";
            }
            if (descs.size() == 1) {
                return (String)descs.iterator().next();
            }
            return EString.implode(descs);
        }

        @Override
        public void setListener(Runnable listener) {
            for (ISymbolProvider provider : this.providers) {
                provider.setListener(listener);
            }
        }
    }
}

