/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.connection.rendering.ConnectionCrossings;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionCrossingsNode;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;

public class ConnectionCrossingsParticipant
extends AbstractDiagramParticipant {
    private static final String CONNECTION_CROSSINGS_NODE_KEY = "connection-crossings";
    private ConnectionCrossingsNode ccNode;
    private final ConnectionCrossings crossings = new ConnectionCrossings();
    private ConnectionCrossingStyleListener listener;
    private Resource diagram;

    public ConnectionCrossingsParticipant(Resource diagram) {
        this.diagram = diagram;
    }

    public ConnectionCrossingsParticipant(double width, ConnectionCrossings.Type type) {
        this.crossings.setWidth(width);
        this.crossings.setType(type);
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        this.ccNode = (ConnectionCrossingsNode)parent.addNode(CONNECTION_CROSSINGS_NODE_KEY, ConnectionCrossingsNode.class);
        this.ccNode.setCrossings(this.crossings);
        this.ccNode.setZIndex(-536870912);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.ccNode != null) {
            this.ccNode.remove();
            this.ccNode = null;
        }
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        if (this.diagram != null) {
            this.listener = new ConnectionCrossingStyleListener(ctx);
            Simantics.getSession().async((ReadInterface)new UnaryRead<Resource, Pair<Double, ConnectionCrossings.Type>>(this.diagram){

                public Pair<Double, ConnectionCrossings.Type> perform(ReadGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    Double gap = (Double)graph.getPossibleRelatedValue(ConnectionCrossingsParticipant.this.diagram, DIA.ConnectionCrossingStyle_Width);
                    Resource typeRes = graph.getPossibleObject(ConnectionCrossingsParticipant.this.diagram, DIA.ConnectionCrossingStyle_HasType);
                    ConnectionCrossings.Type type = DIA.ConnectionCrossingStyle_Type_Gap.equals(typeRes) ? ConnectionCrossings.Type.GAP : (DIA.ConnectionCrossingStyle_Type_Arc.equals(typeRes) ? ConnectionCrossings.Type.ARC : (DIA.ConnectionCrossingStyle_Type_Square.equals(typeRes) ? ConnectionCrossings.Type.SQUARE : ConnectionCrossings.Type.NONE));
                    return new Pair((Object)gap, (Object)type);
                }
            }, (Listener)this.listener);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        super.removedFromContext(ctx);
    }

    class ConnectionCrossingStyleListener
    implements Listener<Pair<Double, ConnectionCrossings.Type>> {
        ICanvasContext context;

        public ConnectionCrossingStyleListener(ICanvasContext context) {
            this.context = context;
        }

        public void execute(final Pair<Double, ConnectionCrossings.Type> result) {
            this.context.getThreadAccess().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ICanvasContext ctx = ConnectionCrossingStyleListener.this.context;
                    if (ctx == null) {
                        return;
                    }
                    if (ctx.isDisposed()) {
                        return;
                    }
                    ((ConnectionCrossingStyleListener)ConnectionCrossingStyleListener.this).ConnectionCrossingsParticipant.this.crossings.setWidth(result.first != null ? (Double)result.first : 0.0);
                    ((ConnectionCrossingStyleListener)ConnectionCrossingStyleListener.this).ConnectionCrossingsParticipant.this.crossings.setType((ConnectionCrossings.Type)result.second);
                    ((ConnectionCrossingStyleListener)ConnectionCrossingStyleListener.this).ConnectionCrossingsParticipant.this.ccNode.repaint();
                }
            });
        }

        public void dispose() {
            this.context = null;
        }

        public boolean isDisposed() {
            return this.context == null || this.context.isDisposed();
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }
    }
}

