/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.diagram.elements.TextElementNoBounds;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.utils.Alignment;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TextElementHandler
extends TextElementNoBounds
implements InternalSize {
    private static final long serialVersionUID = 2560598115620905271L;
    public static final TextElementHandler INSTANCE = new TextElementHandler();

    public TextElementHandler() {
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment) {
        super(originX, originY, horizontalAlignment);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth) {
        super(originX, originY, horizontalAlignment, borderWidth);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable) {
        super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable, double scale) {
        super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable, scale);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, Alignment verticalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable, double scale) {
        super(originX, originY, horizontalAlignment, verticalAlignment, borderWidth, paddingX, paddingY, editable, scale);
    }

    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        return TextElementHandler.calculateBounds(e, size, this.horizontalAlignment, this.scale, this.paddingX, this.paddingY);
    }

    public static Rectangle2D calculateBounds(IElement e, Rectangle2D size, Alignment horizontalAlignment, double scale, double paddingX, double paddingY) {
        TextNode node = (TextNode)((Object)e.getHint(SG_NODE));
        Rectangle2D b = (Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS);
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        if (node != null) {
            size.setRect(node.getBoundsInLocal());
        } else if (b != null && ((Boolean)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_RESIZABLE, (Object)false)).booleanValue()) {
            size.setRect(b);
        } else {
            String text = (String)e.getHint(ElementHints.KEY_TEXT);
            Font font = (Font)e.getHint(ElementHints.KEY_FONT);
            if (text == null || font == null) {
                size.setFrame(0.0, 0.0, 0.0, 0.0);
            } else {
                FontRenderContext FRC = new FontRenderContext(new AffineTransform(), true, true);
                TextLayout tl = new TextLayout(text, font, FRC);
                Rectangle2D bounds = tl.getLogicalHighlightShape(0, text.length()).getBounds2D();
                size.setFrame(TextElementHandler.getAlignedXCoordinate(bounds, horizontalAlignment) * scale - paddingX, bounds.getY() * scale - paddingY, bounds.getWidth() * scale + paddingX + paddingX, bounds.getHeight() * scale + paddingY + paddingY);
            }
        }
        return size;
    }

    public static double getAlignedXCoordinate(Rectangle2D bounds, Alignment horizontalAlignment) {
        if (horizontalAlignment == Alignment.CENTER) {
            return bounds.getX() - bounds.getWidth() / 2.0;
        }
        if (horizontalAlignment == Alignment.TRAILING) {
            return -bounds.getWidth();
        }
        return bounds.getX();
    }
}

