/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import junit.framework.TestCase;

import org.junit.Test;
import org.simantics.databoard.util.URIUtil;

public class TestURIUtil extends TestCase {

    public static final String URI1 = "first/second%third fourth_fifth";
    public static final String URI2 = "3first/second%third fourth_fifth";
    public static final String URI3 = "#3first/second%third fourth_fifth";

    @Test
    public void testEncode() {
        assertEquals("first$2fsecond$25third_fourth$5ffifth", URIUtil.encodeIdentifier(URI1));
        assertEquals("first%2fsecond%25third_fourth%5ffifth", URIUtil.encodeURI(URI1));
        assertEquals("_3first$2fsecond$25third_fourth$5ffifth", URIUtil.encodeIdentifier(URI2));
        assertEquals("3first%2fsecond%25third_fourth%5ffifth", URIUtil.encodeURI(URI2));
        assertEquals("3first/second%third fourth_fifth", URIUtil.decodeIdentifier(URIUtil.encodeIdentifier(URI2)));
        assertEquals("3first/second%third fourth_fifth", URIUtil.decodeURI(URIUtil.encodeURI(URI2)));
        assertEquals("%233first%2fsecond%25third_fourth%5ffifth", URIUtil.encodeURI(URI3));
        assertEquals("#3first/second%third fourth_fifth", URIUtil.decodeURI(URIUtil.encodeURI(URI3)));
    }

    @Test
    public void testDecode() {
    }

}
