/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;

public class DeepClone {
	
	public static void main(String[] args) throws BindingConstructionException, BindingException, AdaptException {

		// Binding can copy objects. All copies are deep. 
		// Mutable objects are duplicated, immutable are referenced.
		
		// For instance, in object array, the array is copied, but its
		// immutable literal instances (e.g. 1) is referenced.
		
		Object[] original = new Object[] { new Object(), 1, "X", 123.456 };
		Binding binding = Bindings.getBinding( original.getClass() );
		Object[] copy = (Object[]) binding.cloneUnchecked( original );

		// Print the objects
		System.out.println( "Original: "+binding.toString( original ) );
		System.out.println( "Clone   : "+binding.toString( copy     ) );
		
	}

}
