/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.variable.impl;

import java.util.ArrayDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.simantics.simulator.variable.Realm;

public class SimpleRealm
implements Realm {
    private ArrayDeque<Runnable> tasks = new ArrayDeque();
    private Semaphore taskCount = new Semaphore(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks() {
        while (this.taskCount.tryAcquire()) {
            Runnable task;
            ArrayDeque<Runnable> arrayDeque = this.tasks;
            synchronized (arrayDeque) {
                task = this.tasks.poll();
            }
            task.run();
        }
    }

    public void waitTasks(long waitDuration) throws InterruptedException {
        this.taskCount.tryAcquire(waitDuration, TimeUnit.MILLISECONDS);
    }

    @Override
    public void syncExec(final Runnable runnable) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                latch.countDown();
            }
        });
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncExec(Runnable runnable) {
        ArrayDeque<Runnable> arrayDeque = this.tasks;
        synchronized (arrayDeque) {
            this.tasks.add(runnable);
        }
        this.taskCount.release();
    }
}

