package org.simantics.scl.osgi.internal;

import java.util.Hashtable;
import java.util.concurrent.ForkJoinPool;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.ProceduralModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.SourceRepositories;
import org.simantics.scl.osgi.SCLOsgi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator implements BundleActivator {

    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);

    public static final String PLUGIN_ID = "org.simantics.scl.osgi";

    private static BundleContext context;

    public static BundleContext getContext() {
        return context;
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    public void start(BundleContext bundleContext) throws Exception {
        Activator.context = bundleContext;

        Hashtable properties = new Hashtable();
        bundleContext.registerService(ModuleSourceRepository.class,
                SourceRepositories.BUILTIN_SOURCE_REPOSITORY,
                properties);
        bundleContext.registerService(ModuleSourceRepository.class,
                new ProceduralModuleSourceRepository() {
                    @Override
                    protected ModuleRepository getModuleRepository(UpdateListener listener) {
                        return SCLOsgi.MODULE_REPOSITORY;
                    }
                },
                properties);
        // Let's try to compile StandardLibrary asynchronously to speed up
        // the compilation when we actually need it the first time
        LOGGER.info("Warming up SCL-compiler with StandardLibrary");
        ForkJoinPool.commonPool().submit(() -> {
            Failable<Module> module = SCLOsgi.MODULE_REPOSITORY.getModule("StandardLibrary");
            LOGGER.info("StandardLibrary compiled {}", module);
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Activator.context = null;
    }

}
