package org.simantics.scl.osgi;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.tuple.Tuple0;

public class SCLProgressMonitor implements IProgressMonitor {

	int recordedWork = 0;
	String currentSubtask = "";
	
    private final Function2<String, Float, Tuple0> beginTask;
    private final Function1<Tuple0, Tuple0> done;
    private final Function1<Tuple0, Boolean> isCanceled;
    private final Function1<Boolean, Tuple0> setCanceled;
    private final Function1<String, Tuple0> setTaskName;
    private final Function1<String, Tuple0> subTask;
    private final Function1<Float, Tuple0> worked;

    public SCLProgressMonitor(Function2<String, Float, Tuple0> beginTask, Function1<Tuple0, Tuple0> done,
            Function1<Tuple0, Boolean> isCanceled, Function1<Boolean, Tuple0> setCanceled,
            Function1<String, Tuple0> setTaskName, Function1<String, Tuple0> subTask, Function1<Float, Tuple0> worked) {
        this.beginTask = beginTask;
        this.done = done;
        this.isCanceled = isCanceled;
        this.setCanceled = setCanceled;
        this.setTaskName = setTaskName;
        this.subTask = subTask;
        this.worked = worked;
    }
    
    @Override
    public void beginTask(String name, int totalWork) {
        beginTask.apply(name, new Float(totalWork));
    }

    @Override
    public void done() {
        done.apply(Tuple0.INSTANCE);
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return isCanceled.apply(Tuple0.INSTANCE);
    }

    @Override
    public void setCanceled(boolean value) {
        setCanceled.apply(value);
    }

    @Override
    public void setTaskName(String name) {
        setTaskName.apply(name);
    }

    @Override
    public void subTask(String name) {
        subTask.apply(name);
        currentSubtask = name;
    }

    @Override
    public void worked(int work) {
        worked.apply(new Float(work));
        recordedWork += work;
    }
    
    public float getWork() {
    	return recordedWork;
    }

    public String getSubTask() {
    	return currentSubtask;
    }

}
