/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Antti Villberg
 */
public class ProfileActiveEntryResources extends ProfileEntryResources {

    SimulationResource SIMU;

    public ProfileActiveEntryResources(Resource activationResource, Resource entry) {
        super(activationResource, entry);
    }

    @Override
    protected boolean test(ReadGraph graph, Resource activeProfile, Resource entry) throws DatabaseException {
        return graph.hasStatement(activeProfile, SIMU.IsActive, entry);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        this.SIMU = SimulationResource.getInstance(graph);
        return super.perform(graph);
    }

}
