/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile;

import org.simantics.db.Resource;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;

/**
 * @author Antti Villberg
 * 
 * @see ProfileKeys
 */
public interface EvaluationContext extends Observer {

    /**
     * @return the runtime resource this evaluation context is attached to (i.e.
     *         runtime diagram resource)
     */
    Resource getResource();

    /**
     * @return the scene graph this profile evaluation context is attached to
     */
    G2DSceneGraph getSceneGraph();

    /**
     * Get a constant data item attached to the evaluation context by the
     * evaluation system.
     * 
     * @param key
     * @return
     * @see ProfileKeys
     */
    <T> T getConstant(String key);

    /**
     * Get the specified temporary property for the specified node. Temporary
     * properties are removed between each round of application of currently
     * active profile entries.
     * 
     * @param node node to get the property for
     * @param key key of property to get
     * @return <code>null</code> if property is not set for the specified node
     */
    <T> T getTemporaryProperty(INode node, String key);

    /**
     * Set value of temporary property for the evaluation process where this
     * evaluation context is used. Temporary properties are removed between each
     * round of application of currently active profile entries.
     * 
     * @param node node to set the property for
     * @param key key of property to set
     * @param value value of the property to set
     */
    <T> void setTemporaryProperty(INode node, String key, T value);

    /**
     * Get the specified (persistent) property for the specified node. These
     * properties stay available through the lifetime of the evaluation context
     * i.e. the lifetime of the runtime diagram it is associated with.
     * 
     * @param node node to get the property for
     * @param key key of property to get
     * @return <code>null</code> if property is not set for the specified node
     */
    <T> T getProperty(INode node, String key);

    /**
     * Set value of temporary property for the evaluation process where this
     * evaluation context is used. These properties stay available through the
     * lifetime of the evaluation context i.e. the lifetime of the runtime
     * diagram it is associated with.
     * 
     * @param node node to set the property for
     * @param key key of property to set
     * @param value value of the property to set
     * @return previous value of property
     */
    <T> T setProperty(INode node, String key, T value);

}
