/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal;

import java.util.List;

import com.sun.jna.Native;
import com.sun.jna.Structure;

/**
 * This should work for Linux, MacOSX and BSD.

 * @author Tuukka Lehtonen
 * @since 1.29.0
 */
public interface Resource32 extends Resource {
    Resource32 INSTANCE = Native.loadLibrary("c", Resource32.class);

    public static class Timeval extends Structure {

        public static final List<String> FIELDS = createFieldsOrder("tv_sec", "tv_usec");

        int v_sec;    /* seconds */
        int tv_usec;  /* microseconds */

        public List<String> getFieldOrder() {
            return FIELDS;
        }
    };

    public static class Rusage extends Structure {

        public static final List<String> FIELDS = createFieldsOrder("ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss",
                "ru_idrss", "ru_isrss", "ru_minflt", "ru_maxflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd",
                "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw");

        Timeval ru_utime;        /* user CPU time used */
        Timeval ru_stime;        /* system CPU time used */
        long   ru_maxrss;        /* maximum resident set size */
        long   ru_ixrss;         /* integral shared memory size */
        long   ru_idrss;         /* integral unshared data size */
        long   ru_isrss;         /* integral unshared stack size */
        long   ru_minflt;        /* page reclaims (soft page faults) */
        long   ru_majflt;        /* page faults (hard page faults) */
        long   ru_nswap;         /* swaps */
        long   ru_inblock;       /* block input operations */
        long   ru_oublock;       /* block output operations */
        long   ru_msgsnd;        /* IPC messages sent */
        long   ru_msgrcv;        /* IPC messages received */
        long   ru_nsignals;      /* signals received */
        long   ru_nvcsw;         /* voluntary context switches */
        long   ru_nivcsw;        /* involuntary context switches */

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public void writeTo(CMemoryInfo to) {
            to.peakRSS = ru_maxrss;
        }

    }

    int getrusage(int who, Rusage rusage);
}
