/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal;

/**
 * @author Tuukka Lehtonen
 * @since 1.29.0
 */
public interface Resource {

    int RUSAGE_SELF = 0;
    int RUSAGE_CHILDREN = -1;
    int RUSAGE_BOTH = -2;  /* sys_wait4() uses this */
    int RUSAGE_THREAD = 1; /* only the calling thread */

    /**
     * Size of a page in bytes. Must not be less than 1. (Some systems use
     * PAGE_SIZE instead.)
     */
    int _SC_PAGESIZE = 30;

    long sysconf(int name);

}