/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.representation;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * An interface for fetching string representations for a resource. Also
 * supports handling of vector-valued resources.
 * 
 * @author Tuukka Lehtonen
 */
public interface StringRepresentation2 {

    /**
     * @return a string representation of the underlying resource
     */
    String get(ReadGraph g) throws DatabaseException;

    /**
     * If the underlying resource contains a value, this method can be used
     * retrieve its array size.
     * 
     * @return -1 if there is no value, >= 0 otherwise.
     */
    int getArraySize(ReadGraph g) throws DatabaseException;

    /**
     * If the underlying resource contains a value, this method can be used to
     * get a string representation of one of its indices.
     * 
     * @param index
     * @return
     */
    String get(ReadGraph g, int index) throws DatabaseException;

    /**
     * If the underlying resource contains a value, this method can be used to
     * get a string representation of the specified sequential range of indices.
     * 
     * @param start
     * @param size
     * @return
     */
    String get(ReadGraph g, int start, int size) throws DatabaseException;

}
