/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.util.Collections;
import java.util.Set;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayerListener;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;

public class SimpleElementLayers
implements ElementLayers {
    public static final SimpleElementLayers INSTANCE = new SimpleElementLayers();
    private static final long serialVersionUID = 379502115902223354L;

    @Override
    public boolean isVisible(IElement e, ILayers layers) {
        assert (e != null);
        assert (layers != null);
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);
    }

    @Override
    public boolean isVisible(IElement e, ILayer layer) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return elementLayers.contains(layer);
    }

    @Override
    public boolean isFocusable(IElement e, ILayers layers) {
        assert (e != null);
        assert (layers != null);
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);
    }

    @Override
    public boolean isFocusable(IElement e, ILayer layer) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return elementLayers.contains(layer);
    }

    @Override
    public boolean setVisibility(IElement e, ILayer layer, boolean value) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null) {
            return false;
        }
        boolean result = value ? elementLayers.add(layer) : elementLayers.remove(layer);
        if (result) {
            for (ElementLayerListener ell : e.getElementClass().getItemsByClass(ElementLayerListener.class)) {
                ell.visibilityChanged(e, layer, value);
            }
        }
        return result;
    }

    @Override
    public boolean setFocusability(IElement e, ILayer layer, boolean value) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null) {
            return false;
        }
        boolean result = value ? elementLayers.add(layer) : elementLayers.remove(layer);
        if (result) {
            for (ElementLayerListener ell : e.getElementClass().getItemsByClass(ElementLayerListener.class)) {
                ell.focusabilityChanged(e, layer, value);
            }
        }
        return result;
    }
}

