package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public  class NestedComparator<T> implements Comparator<T> {
	List<Comparator<T>> comparators = new ArrayList<Comparator<T>>();
	
	public void addComparator(Comparator<T> c) {
		comparators.add(c);
	}
	
	public int compare(T o1, T o2) {
		for (Comparator<T> c : comparators) {
			int v = c.compare(o1, o2);
			if (v != 0)
				return v;
		}
		return 0;
	};
}
