package org.simantics.document.linking.report.html;

import java.util.List;

import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.Document.TextSize;


public class HTMLTitlePage extends DocumentTitlePage implements HTMLElement{
	
	HTMLDocument writer;
	public HTMLTitlePage(HTMLDocument writer) {
		this.writer = writer;
	}
	
	@Override
	public void writeTitle(List<DocumentLine> lines) throws Exception {
		writer.nextPage();
		for (DocumentLine line : lines) {
			String hTag = "h4"; //$NON-NLS-1$
			if (line.getHints().containsKey(TextSize.class)) {
				TextSize size = (TextSize)line.getHints().get(TextSize.class);
				switch (size) {
				case HUGE:
					hTag = "h1"; //$NON-NLS-1$
					break;
				case LARGE:
					hTag = "h2"; //$NON-NLS-1$
					break;
				case MEDIUM:
					hTag = "h3"; //$NON-NLS-1$
					break;
				case SMALL:
					hTag = "h4"; //$NON-NLS-1$
					break;
				case TINY:
					hTag = "h5"; //$NON-NLS-1$
					break;
				default:
					break;
				}
			}
			writer.os.println("<"+hTag +">" + line.getLine() + "</"+hTag+">"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}
		writer.nextPage();
		
	}
	
	@Override
	public String getId() {
		return null;
	}

}
