package org.simantics.document.linking.adapters;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;

public class DiagramElementAdapter implements  SourceObjectAdapter{
	
	@Override
	public Resource getDocumentableResource(ReadGraph graph, Resource selected) throws DatabaseException {
		ModelingResources mr = ModelingResources.getInstance(graph);
		DiagramResource dr = DiagramResource.getInstance(graph);
		if (graph.isInstanceOf(selected, dr.Element)) {
			Resource r = graph.getPossibleObject(selected, mr.ElementToComponent);
			if (r != null)
				return r;
		}
		return selected;
	}

}
