/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.simantics.g3d.vtk.Activator;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.swt.vtkCameraAndSelectorAction;
import vtk.vtkProp;
import vtk.vtkProp3D;

public class FocusAction
extends Action {
    VtkView view;
    vtkCameraAndSelectorAction cameraAndSelectorAction;
    Collection<vtkProp> props;

    public FocusAction(VtkView view, vtkCameraAndSelectorAction cameraAndSelectorAction) {
        super("Focus");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/eye.png"));
        this.view = view;
        this.cameraAndSelectorAction = cameraAndSelectorAction;
    }

    public void setProps(Collection<vtkProp> props) {
        this.props = props;
    }

    public void run() {
        this.view.getThreadQueue().asyncExec(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                double[] loc = new double[]{0.0, 0.0, 0.0};
                for (vtkProp prop : FocusAction.this.props) {
                    if (!(prop instanceof vtkProp3D)) continue;
                    vtkProp3D prop3d = (vtkProp3D)prop;
                    double[] l = prop3d.GetCenter();
                    int i = 0;
                    while (i < 3) {
                        loc[i] = loc[i] + l[i];
                        ++i;
                    }
                    ++count;
                }
                if (count > 0) {
                    int i = 0;
                    while (i < 3) {
                        loc[i] = loc[i] / (double)count;
                        ++i;
                    }
                    FocusAction.this.cameraAndSelectorAction.focus(loc[0], loc[1], loc[2]);
                    FocusAction.this.view.refresh();
                }
            }
        });
    }
}

