/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.vtkShape;
import vtk.vtkActor;
import vtk.vtkProp;

public class ConstraintDetector
extends org.simantics.g3d.tools.ConstraintDetector {
    VtkView renderingPart;
    private List<vtkProp> parts = new ArrayList<vtkProp>();

    public ConstraintDetector(VtkView renderingPart) {
        this.renderingPart = renderingPart;
    }

    protected void addConstrainLineHighlight(Point3d p1, Point3d p2, Color4d color) {
        double w = 3.0;
        vtkActor lineActorX = vtkShape.createLineActor((Tuple3d)p1, (Tuple3d)p2);
        lineActorX.GetProperty().SetColor(color.x, color.y, color.z);
        lineActorX.GetProperty().SetLineWidth(w);
        lineActorX.GetProperty().Delete();
        this.parts.add((vtkProp)lineActorX);
        this.renderingPart.lock();
        this.renderingPart.getRenderer().AddActor((vtkProp)lineActorX);
        this.renderingPart.unlock();
    }

    protected void addConstrainPlaneHighlight(Point3d p1, Point3d p2, int axis) {
        double w = 3.0;
        Point3d p12 = new Point3d();
        Color4d color = this.xColor;
        switch (axis) {
            case 0: {
                p12.x = p1.x;
                p12.y = p1.y;
                p12.z = p2.z;
                color = this.xColor;
                break;
            }
            case 1: {
                p12.x = p1.x;
                p12.y = p1.y;
                p12.z = p2.z;
                color = this.yColor;
                break;
            }
            case 2: {
                p12.x = p1.x;
                p12.y = p2.y;
                p12.z = p2.z;
                color = this.zColor;
            }
        }
        vtkActor lineActorX = vtkShape.createLineActor(new Tuple3d[]{p1, p12, p2});
        lineActorX.GetProperty().SetColor(color.x, color.y, color.z);
        lineActorX.GetProperty().SetLineWidth(w);
        lineActorX.GetProperty().Delete();
        this.parts.add((vtkProp)lineActorX);
        this.renderingPart.lock();
        this.renderingPart.getRenderer().AddActor((vtkProp)lineActorX);
        this.renderingPart.unlock();
    }

    public void clearConstraintHighlights() {
        this.clearSnapString();
        if (this.parts.size() == 0) {
            return;
        }
        this.renderingPart.lock();
        for (vtkProp p : this.parts) {
            this.renderingPart.getRenderer().RemoveActor(p);
            p.Delete();
        }
        this.parts.clear();
        this.renderingPart.unlock();
    }
}

