/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.IMappingListener;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vtk.vtkProp;

public abstract class AbstractVTKNodeMap<DBObject, E extends INode>
implements VTKNodeMap<DBObject, E>,
IMappingListener,
RenderListener,
NodeListener,
UndoRedoSupport.ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVTKNodeMap.class);
    protected Session session;
    protected IMapping<DBObject, INode> mapping;
    protected VtkView view;
    private MapList<E, vtkProp> nodeToActor = new MapList();
    private Map<vtkProp, E> actorToNode = new HashMap<vtkProp, E>();
    protected ParentNode<E> rootNode;
    protected UndoRedoSupport undoRedoSupport;
    protected int undoOpCount = 0;
    protected int redoOpCount = 0;
    protected boolean runUndo = false;
    protected boolean runRedo = false;
    private boolean changeTracking = true;
    protected Object syncMutex = new Object();
    private List<Pair<E, String>> added = new ArrayList<Pair<E, String>>();
    private List<Pair<E, String>> removed = new ArrayList<Pair<E, String>>();
    private MapSet<E, String> updated = new MapSet.Hash();
    private boolean rangeModified = false;
    private boolean graphUpdates = false;
    private Set<E> graphModified = new HashSet();
    private boolean requestCommit = false;
    private String commitMessage = null;
    private boolean useFullSyncWithUndo = false;
    List<Pair<E, String>> rem = new ArrayList<Pair<E, String>>();
    List<Pair<E, String>> add = new ArrayList<Pair<E, String>>();
    MapSet<E, String> mod = new MapSet.Hash();
    Set<E> propagation = new HashSet();
    Stack<E> stack = new Stack();
    Set<E> delete = Collections.synchronizedSet(new HashSet());
    Set<E> deleteUC = new HashSet();
    private List<NodeListener> nodeListeners = new ArrayList<NodeListener>();

    public AbstractVTKNodeMap(Session session, IMapping<DBObject, INode> mapping, VtkView view, ParentNode<E> rootNode) {
        this.session = session;
        this.mapping = mapping;
        this.view = view;
        this.rootNode = rootNode;
        view.addListener(this);
        mapping.addMappingListener((IMappingListener)this);
        rootNode.addListener((NodeListener)this);
        this.undoRedoSupport = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        this.undoRedoSupport.subscribe((UndoRedoSupport.ChangeListener)this);
        try {
            UndoContext undoContext = this.undoRedoSupport.getUndoContext(session);
            this.undoOpCount = undoContext.getAll().size();
            this.redoOpCount = undoContext.getRedoList().size();
        }
        catch (DatabaseException e) {
            LOGGER.error("Error reading from undo context", (Throwable)e);
        }
    }

    protected abstract void addActor(E var1);

    protected abstract void removeActor(E var1);

    protected abstract void updateActor(E var1, Set<String> var2);

    public void repaint() {
        this.view.refresh();
    }

    public void populate() {
        for (INode node : this.rootNode.getNodes()) {
            this.receiveAdd(node, node.getParentRel(), true);
        }
        this.repaint();
    }

    public E getNode(vtkProp prop) {
        return (E)((INode)this.actorToNode.get(prop));
    }

    public Collection<vtkProp> getRenderObjects(INode node) {
        return this.nodeToActor.getValues((Object)node);
    }

    protected <T extends vtkProp> void map(E node, Collection<T> props) {
        for (vtkProp p : props) {
            this.nodeToActor.add(node, (Object)p);
            this.actorToNode.put(p, node);
        }
    }

    protected void removeMap(E node) {
        List coll = this.nodeToActor.getValuesUnsafe(node);
        if (coll.size() > 0) {
            this.view.lock();
            for (vtkProp p : coll) {
                this.actorToNode.remove(p);
                if (p.GetVTKId() == 0L) continue;
                this.view.getRenderer().RemoveActor(p);
                p.Delete();
            }
            this.view.unlock();
        }
        this.nodeToActor.remove(node);
    }

    public ParentNode<E> getRootNode() {
        return this.rootNode;
    }

    public boolean isChangeTracking() {
        return this.changeTracking;
    }

    public void setChangeTracking(boolean enabled) {
        this.changeTracking = enabled;
    }

    public boolean isRangeModified() {
        return this.rangeModified;
    }

    public void onChanged() {
        try {
            UndoContext undoContext = this.undoRedoSupport.getUndoContext(this.session);
            int ucount = undoContext.getAll().size();
            int rcount = undoContext.getRedoList().size();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Previous U:" + this.undoOpCount + " R:" + this.redoOpCount + " Current U:" + ucount + " R:" + rcount);
            }
            this.runUndo = ucount < this.undoOpCount;
            this.runRedo = !this.runUndo && rcount > 0;
            this.undoOpCount = ucount;
            this.redoOpCount = rcount;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Undo " + this.runUndo + " Redo " + this.runRedo);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void updateRenderObjectsFor(E node) {
        ArrayList<vtkProp> toDelete = new ArrayList<vtkProp>();
        this.view.lock();
        for (vtkProp prop : this.nodeToActor.getValues(node)) {
            if (prop.GetVTKId() != 0L) {
                this.view.getRenderer().RemoveActor(prop);
                toDelete.add(prop);
            }
            this.actorToNode.remove(prop);
        }
        this.view.unlock();
        this.nodeToActor.remove(node);
        Collection<vtkProp> coll = this.getActors(node);
        if (coll != null) {
            for (vtkProp prop : coll) {
                this.nodeToActor.add(node, (Object)prop);
                this.actorToNode.put(prop, node);
                toDelete.remove(prop);
            }
        }
        for (vtkProp p : toDelete) {
            p.Delete();
        }
    }

    protected abstract Collection<vtkProp> getActors(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAdd(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveAdd " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.added) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking) {
                this.mapping.rangeModified((Object)node.getParent());
                this.mapping.rangeModified(node);
            }
            this.added.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemove(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveRemove " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.removed) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
                this.mapping.rangeModified((Object)node.getParent());
            }
            this.removed.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveUpdate(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveUpdate " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
            }
            this.updated.add(node, (Object)id);
            this.rangeModified = true;
        }
        this.repaint();
    }

    public void commit(String message) {
        this.requestCommit = true;
        this.commitMessage = message;
    }

    protected void doCommit() {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(monitor -> {
                try {
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Commit " + AbstractVTKNodeMap.this.commitMessage);
                            }
                            if (AbstractVTKNodeMap.this.commitMessage != null) {
                                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)AbstractVTKNodeMap.this.commitMessage);
                                graph.markUndoPoint();
                                AbstractVTKNodeMap.this.commitMessage = null;
                            }
                            AbstractVTKNodeMap.this.commit(graph);
                        }
                    });
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)"Cannot commit editor changes", (Throwable)e);
                }
            });
            this.postCommit();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error("Unexpected exception", (Throwable)e);
        }
    }

    protected void postCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(WriteGraph graph) throws DatabaseException {
        Object object = this.syncMutex;
        synchronized (object) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit");
            }
            this.graphUpdates = true;
            this.mapping.updateDomain(graph);
            this.graphUpdates = false;
            this.clearDeletes();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit done");
            }
        }
    }

    public void domainModified() {
        if (this.graphUpdates) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("domainModified");
        }
        this.session.asyncRequest((Read)new UniqueRead<Object>(){

            public Object perform(ReadGraph graph) throws DatabaseException {
                return new Object();
            }
        }, (SyncProcedure)new SyncProcedure<Object>(){

            public void execute(ReadGraph graph, Object result) throws DatabaseException {
                AbstractVTKNodeMap.this.update(graph);
            }

            public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                LOGGER.error("Failed to update pipeline changes" + throwable);
            }
        });
    }

    protected void reset(ReadGraph graph) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reset");
        }
        this.graphUpdates = true;
        this.mapping.getRangeModified().clear();
        for (Object o : this.mapping.getDomain()) {
            this.mapping.domainModified(o);
        }
        this.mapping.updateRange(graph);
        this.graphModified.clear();
        this.graphUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ReadGraph graph) throws DatabaseException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update start");
        }
        if (this.runUndo && this.useFullSyncWithUndo) {
            Object object = this.syncMutex;
            synchronized (object) {
                this.reset(graph);
            }
        }
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            for (Object domainObject : this.mapping.getDomainModified()) {
                INode rangeObject = (INode)this.mapping.get(domainObject);
                if (rangeObject == null) continue;
                this.graphModified.add(rangeObject);
            }
        }
        this.mapping.updateRange(graph);
        object = this.syncMutex;
        synchronized (object) {
            this.graphModified.clear();
            this.syncDeletes();
        }
        this.clearDeletes();
        this.graphUpdates = false;
        if (this.mapping.isRangeModified() && !this.runUndo && !this.runRedo) {
            this.commit((String)null);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update done");
        }
    }

    public void rangeModified() {
    }

    public void postRender() {
        if (this.requestCommit && !this.rangeModified) {
            this.requestCommit = false;
            this.doCommit();
        }
    }

    public synchronized void preRender() {
        this.updateCycle();
    }

    protected void syncDeletes() {
        this.deleteUC.clear();
        for (Pair<E, String> pair : this.removed) {
            this.deleteUC.add((INode)pair.first);
        }
        for (Pair<E, String> pair : this.added) {
            this.deleteUC.remove(pair.first);
        }
        if (LOGGER.isTraceEnabled() && this.deleteUC.size() > 0) {
            LOGGER.trace("Delete sync");
            for (INode iNode : this.delete) {
                LOGGER.trace(this.debugString(iNode));
            }
        }
        this.delete.addAll(this.deleteUC);
        this.deleteUC.clear();
    }

    protected void clearDeletes() {
        if (LOGGER.isTraceEnabled() && this.delete.size() > 0) {
            LOGGER.trace("Delete");
        }
        for (INode n : this.delete) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(this.debugString(n));
            }
            this.mapping.getRange().remove(n);
            this.stopListening(n);
        }
        this.delete.clear();
    }

    protected String debugString(E n) {
        return n + "@" + Integer.toHexString(n.hashCode());
    }

    protected boolean filterChange(List<Pair<E, String>> list, E n) {
        int i = list.size() - 1;
        while (i >= 0) {
            if (list.get((int)i).first == n) {
                list.remove(i);
                return true;
            }
            --i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCycle() {
        this.rem.clear();
        this.add.clear();
        this.mod.clear();
        this.propagation.clear();
        Object object = this.syncMutex;
        synchronized (object) {
            Iterator<Object> stack = new ArrayDeque<INode>();
            for (Pair<E, String> pair : this.added) {
                stack.add((INode)pair.first);
            }
            while (!stack.isEmpty()) {
                INode iNode = (INode)stack.pop();
                boolean conflict = this.filterChange(this.removed, iNode);
                if (conflict) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Prevent removing " + iNode);
                    }
                    if (this.filterChange(this.added, iNode) && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Prevent adding " + iNode);
                    }
                }
                if (!(iNode instanceof ParentNode)) continue;
                ParentNode pn = (ParentNode)iNode;
                for (INode cn : pn.getNodes()) {
                    stack.push(cn);
                }
            }
            for (Pair<E, String> pair : this.removed) {
                this.updated.removeValues((Object)((INode)pair.first));
            }
            this.rem.addAll(this.removed);
            this.add.addAll(this.added);
            for (INode iNode : this.updated.getKeys()) {
                for (String s : this.updated.getValues((Object)iNode)) {
                    this.mod.add((Object)iNode, (Object)s);
                }
            }
            this.syncDeletes();
            this.removed.clear();
            this.added.clear();
            this.updated.clear();
        }
        for (Pair pair : this.rem) {
            this.stopListening((INode)pair.first);
            this.removeActor((INode)pair.first);
            ((INode)pair.first).remove();
        }
        for (Pair<E, String> pair : this.add) {
            this.addActor((INode)pair.first);
            this.listen((INode)pair.first);
        }
        for (INode iNode : this.mod.getKeys()) {
            Set set = this.mod.getValues((Object)iNode);
            if (!set.contains("http://www.simantics.org/G3D-0.1/hasPosition") && !set.contains("http://www.simantics.org/G3D-0.1/hasOrientation") || this.propagation.contains(iNode)) continue;
            this.propagation.add(iNode);
        }
        if (this.propagation.size() > 0) {
            this.stack.clear();
            this.stack.addAll(this.propagation);
            this.propagation.clear();
            while (!this.stack.isEmpty()) {
                INode iNode = (INode)this.stack.pop();
                if (this.propagation.contains(iNode)) continue;
                this.propagation.add(iNode);
                for (NodeListener l : iNode.getListeners()) {
                    if (l == this) continue;
                    l.propertyChanged(iNode, "http://www.simantics.org/G3D-0.1/hasWorldPosition");
                }
                if (!(iNode instanceof ParentNode)) continue;
                this.stack.addAll(((ParentNode)iNode).getNodes());
            }
        }
        for (INode iNode : this.mod.getKeys()) {
            Set set = this.mod.getValues((Object)iNode);
            this.updateActor(iNode, set);
        }
        for (Pair pair : this.rem) {
            for (NodeListener nodeListener : this.nodeListeners) {
                nodeListener.nodeRemoved(null, (INode)pair.first, (String)pair.second);
            }
        }
        for (Pair pair : this.add) {
            for (NodeListener nodeListener : this.nodeListeners) {
                nodeListener.nodeAdded(((INode)pair.first).getParent(), (INode)pair.first, (String)pair.second);
            }
        }
        for (INode iNode : this.mod.getKeys()) {
            for (NodeListener nodeListener : this.nodeListeners) {
                for (String s : this.mod.getValues((Object)iNode)) {
                    nodeListener.propertyChanged(iNode, s);
                }
            }
        }
        Object object2 = this.syncMutex;
        synchronized (object2) {
            if (this.added.isEmpty() && this.removed.isEmpty() && this.updated.getKeys().size() == 0) {
                this.rangeModified = false;
            }
        }
    }

    private void listen(INode node) {
        node.addListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.listen(n);
            }
        }
    }

    private void stopListening(INode node) {
        node.removeListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.stopListening(n);
            }
        }
    }

    public void propertyChanged(INode node, String id) {
        this.receiveUpdate(node, id, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node added " + child + " parent " + node);
        }
        this.receiveAdd(child, rel, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node removed " + child + " parent " + node);
        }
        this.receiveRemove(child, rel, this.graphModified.contains(node));
    }

    public void delete() {
        if (this.undoRedoSupport != null) {
            this.undoRedoSupport.cancel((UndoRedoSupport.ChangeListener)this);
        }
        this.changeTracking = false;
        this.view.removeListener(this);
        this.mapping.removeMappingListener((IMappingListener)this);
        ArrayList nodes = new ArrayList(this.nodeToActor.getKeySize());
        nodes.addAll(this.nodeToActor.getKeys());
        for (INode node : nodes) {
            node.removeListener((NodeListener)this);
            this.removeActor(node);
            node.cleanup();
        }
        for (vtkProp prop : this.actorToNode.keySet()) {
            if (prop.GetVTKId() == 0L) continue;
            prop.Delete();
        }
        this.actorToNode.clear();
        this.nodeToActor.clear();
    }

    public void addListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    public void removeListener(NodeListener listener) {
        this.nodeListeners.remove(listener);
    }

    public IMapping<DBObject, INode> getMapping() {
        return this.mapping;
    }
}

