/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.awt;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.vtk.action.vtkAction;
import org.simantics.g3d.vtk.awt.vtkAwtAction;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.scenegraph.utils.DPIUtil;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import vtk.vtkAbstractPicker;
import vtk.vtkAreaPicker;
import vtk.vtkAssemblyNode;
import vtk.vtkAssemblyPath;
import vtk.vtkCellPicker;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorObserver;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkObject;
import vtk.vtkObjectBase;
import vtk.vtkPanel;
import vtk.vtkPointPicker;
import vtk.vtkProp;
import vtk.vtkProp3DCollection;
import vtk.vtkPropCollection;
import vtk.vtkPropPicker;
import vtk.vtkRenderer;
import vtk.vtkScenePicker;

public class InteractiveVtkPanel
extends vtkPanel
implements VtkView {
    protected vtkGenericRenderWindowInteractor iren;
    private static final long serialVersionUID = 2815073937537950615L;
    private vtkScenePicker scenePicker;
    int pickType = 4;
    private vtkAwtAction defaultAction;
    private vtkAwtAction currentAction;
    private List<RenderListener> listeners = new ArrayList<RenderListener>();
    List<RenderListener> list = new ArrayList<RenderListener>();
    private List<vtkObjectBase> deletable = new ArrayList<vtkObjectBase>();

    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.iren;
    }

    public InteractiveVtkPanel() {
        if (!Platform.inDevelopmentMode()) {
            new vtkObject().GlobalWarningDisplayOff();
        }
        this.iren = new vtkGenericRenderWindowInteractor();
        this.iren.SetRenderWindow(this.rw);
        this.iren.TimerEventResetsTimerOff();
        this.iren.SetSize(200, 200);
        this.iren.ConfigureEvent();
        vtkInteractorStyleTrackballCamera style = new vtkInteractorStyleTrackballCamera();
        this.iren.SetInteractorStyle((vtkInteractorObserver)style);
        this.addDeletable((vtkObjectBase)style);
        this.addDeletable((vtkObjectBase)this.iren);
    }

    @Override
    public IThreadWorkQueue getThreadQueue() {
        return AWTThread.getThreadAccess();
    }

    @Override
    public vtkRenderer getRenderer() {
        return this.GetRenderer();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
    }

    public void _setSize(int x, int y) {
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(x, y);
            this.iren.SetSize(x, y);
            this.iren.ConfigureEvent();
            this.UnLock();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._setSize(width, height);
    }

    public int getPickType() {
        return this.pickType;
    }

    public void setPickType(int pickType) {
        this.pickType = pickType;
    }

    public vtkProp[] pick(int x, int y) {
        if (this.pickType == 0) {
            vtkPropPicker picker = new vtkPropPicker();
            this.Lock();
            picker.PickProp((double)x, (double)(this.rw.GetSize()[1] - y), this.ren);
            this.UnLock();
            vtkAssemblyPath apath = picker.GetPath();
            return this.processPick((vtkAbstractPicker)picker, apath);
        }
        if (this.pickType == 1) {
            if (this.scenePicker == null) {
                this.scenePicker = new vtkScenePicker();
                this.scenePicker.SetRenderer(this.ren);
                this.scenePicker.EnableVertexPickingOn();
            }
            this.Lock();
            vtkAssemblyPath apath = this.ren.PickProp((double)x, (double)(this.rw.GetSize()[1] - y));
            this.UnLock();
            if (apath != null) {
                apath.InitTraversal();
                vtkAssemblyNode node = apath.GetLastNode();
                vtkProp test = node.GetViewProp();
                apath.Delete();
                node.Delete();
                return new vtkProp[]{test};
            }
        } else {
            if (this.pickType == 2) {
                vtkPointPicker picker = new vtkPointPicker();
                picker.SetTolerance(1.0E-5);
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkAssemblyPath apath = picker.GetPath();
                return this.processPick((vtkAbstractPicker)picker, apath);
            }
            if (this.pickType == 3) {
                vtkAreaPicker picker = new vtkAreaPicker();
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkAssemblyPath apath = picker.GetPath();
                return this.processPick((vtkAbstractPicker)picker, apath);
            }
            if (this.pickType == 4) {
                vtkCellPicker picker = new vtkCellPicker();
                picker.SetTolerance(1.0E-5);
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkAssemblyPath apath = picker.GetPath();
                return this.processPick((vtkAbstractPicker)picker, apath);
            }
        }
        return null;
    }

    public vtkProp[] pick2(int x, int y) {
        if (this.pickType == 0) {
            vtkPropPicker picker = new vtkPropPicker();
            this.Lock();
            picker.PickProp((double)x, (double)(this.rw.GetSize()[1] - y), this.ren);
            this.UnLock();
            vtkPropCollection coll = picker.GetPickList();
            return this.processPick((vtkAbstractPicker)picker, coll);
        }
        if (this.pickType == 1) {
            if (this.scenePicker == null) {
                this.scenePicker = new vtkScenePicker();
                this.scenePicker.SetRenderer(this.ren);
                this.scenePicker.EnableVertexPickingOn();
            }
            this.Lock();
            vtkAssemblyPath apath = this.ren.PickProp((double)x, (double)(this.rw.GetSize()[1] - y));
            this.UnLock();
            if (apath != null) {
                apath.InitTraversal();
                vtkAssemblyNode node = apath.GetLastNode();
                vtkProp test = node.GetViewProp();
                apath.Delete();
                node.Delete();
                return new vtkProp[]{test};
            }
        } else {
            if (this.pickType == 2) {
                vtkPointPicker picker = new vtkPointPicker();
                picker.SetTolerance(2.0 / (double)this.rw.GetSize()[0]);
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
            if (this.pickType == 3) {
                vtkAreaPicker picker = new vtkAreaPicker();
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
            if (this.pickType == 4) {
                vtkCellPicker picker = new vtkCellPicker();
                picker.SetTolerance(2.0 / (double)this.rw.GetSize()[0]);
                this.Lock();
                picker.Pick(new double[]{x, this.rw.GetSize()[1] - y, 0.0}, this.ren);
                this.UnLock();
                vtkProp3DCollection coll = picker.GetProp3Ds();
                return this.processPick((vtkAbstractPicker)picker, (vtkPropCollection)coll);
            }
        }
        return null;
    }

    private vtkProp[] processPick(vtkAbstractPicker picker, vtkAssemblyPath apath) {
        picker.Delete();
        if (apath != null) {
            apath.InitTraversal();
            vtkProp[] result = new vtkProp[apath.GetNumberOfItems()];
            int i = apath.GetNumberOfItems() - 1;
            while (i >= 0) {
                vtkProp test;
                vtkAssemblyNode node = apath.GetNextNode();
                result[i] = test = node.GetViewProp();
                node.Delete();
                --i;
            }
            apath.Delete();
            return result;
        }
        return null;
    }

    private vtkProp[] processPick(vtkAbstractPicker picker, vtkPropCollection coll) {
        picker.Delete();
        if (coll != null) {
            coll.InitTraversal();
            vtkProp[] result = new vtkProp[coll.GetNumberOfItems()];
            int i = coll.GetNumberOfItems() - 1;
            while (i >= 0) {
                vtkProp test;
                result[i] = test = coll.GetNextProp();
                --i;
            }
            coll.Delete();
            return result;
        }
        return null;
    }

    @Override
    public void setActiveAction(vtkAction action) {
        if (((Object)((Object)action)).equals(this.currentAction)) {
            return;
        }
        if (this.currentAction != null) {
            this.currentAction.deattach();
        }
        this.currentAction = (vtkAwtAction)action;
        if (action != null) {
            action.attach();
        }
    }

    @Override
    public void setDefaultAction(vtkAction defaultAction) {
        this.defaultAction = (vtkAwtAction)defaultAction;
    }

    @Override
    public void useDefaultAction() {
        this.setActiveAction(this.defaultAction);
    }

    @Override
    public vtkAction getDefaultAction() {
        return this.defaultAction;
    }

    public synchronized void Render() {
        if (this.rendering) {
            return;
        }
        this.firePreRender();
        super.Render();
        this.firePostRender();
    }

    @Override
    public void addListener(RenderListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(RenderListener l) {
        this.listeners.remove(l);
    }

    private void firePreRender() {
        if (this.listeners.size() > 0) {
            this.list.addAll(this.listeners);
            for (RenderListener l : this.list) {
                l.preRender();
            }
            this.list.clear();
        }
    }

    private void firePostRender() {
        if (this.listeners.size() > 0) {
            this.list.addAll(this.listeners);
            for (RenderListener l : this.list) {
                l.postRender();
            }
            this.list.clear();
        }
    }

    @Override
    public void addDeletable(vtkObjectBase o) {
        this.deletable.add(o);
    }

    @Override
    public void removeDeletable(vtkObjectBase o) {
        this.deletable.remove(o);
    }

    public void Delete() {
        for (vtkObjectBase o : this.deletable) {
            if (o.GetVTKId() == 0L) continue;
            o.Delete();
        }
        this.deletable.clear();
        super.Delete();
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public double upscale(double d) {
        return DPIUtil.upscale((double)d);
    }

    @Override
    public int upscale(int i) {
        return DPIUtil.upscale((int)i);
    }
}

