/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.simantics.DatabaseBaselines;
import org.simantics.Simantics;
import org.simantics.TimingProgressMonitor;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineCreatorApplication
implements IApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineCreatorApplication.class);
    private static final IArgumentFactory<String> OUTPUT = new IArgumentFactory.StringArgumentFactory("-o");
    private static final IArgumentFactory<Boolean> VERBOSE = new IArgumentFactory.NoValueArgumentFactory("-v");
    private static final IArgumentFactory<String> FUNCTION = new IArgumentFactory.StringArgumentFactory("-f");
    IArgumentFactory<?>[] accepted = new IArgumentFactory[]{SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS, SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL, SimanticsArguments.DISABLE_INDEX, SimanticsArguments.DATABASE_ID, OUTPUT, VERBOSE, FUNCTION};

    private static String currentLocalDateTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmm"));
    }

    private static Path constructOutputPath(Path workspace, IArguments parsedArgs) {
        if (parsedArgs.contains(OUTPUT)) {
            return workspace.resolve((String)parsedArgs.get(OUTPUT));
        }
        return workspace.resolve(String.valueOf(workspace.getFileName().toString()) + "-" + BaselineCreatorApplication.currentLocalDateTimeStamp() + ".zip");
    }

    private static Path getInstanceLocation() throws CoreException, IOException {
        Location l = Platform.getInstanceLocation();
        if (l == null || l.isReadOnly()) {
            throw new CoreException((IStatus)new Status(4, "org.simantics", "Workspace not defined. Use -data <path> argument to define where to place the baselining workspace."));
        }
        URL workspaceUrl = l.getURL();
        Path workspacePath = new File(workspaceUrl.getPath()).toPath();
        Files.createDirectories(workspacePath, new FileAttribute[0]);
        return workspacePath;
    }

    public Object start(IApplicationContext context) throws Exception {
        try {
            Path workspace = BaselineCreatorApplication.getInstanceLocation();
            String[] args = (String[])context.getArguments().get("application.args");
            IArguments parsedArgs = Arguments.parse((String[])args, this.accepted);
            Path output = BaselineCreatorApplication.constructOutputPath(workspace, parsedArgs);
            LOGGER.info("Selected output file: {} ", (Object)output);
            TimingProgressMonitor progress = parsedArgs.contains(VERBOSE) ? new TimingProgressMonitor() : new NullProgressMonitor();
            Simantics.startUpHeadless(parsedArgs, (IProgressMonitor)progress);
            if (parsedArgs.contains(FUNCTION)) {
                String func = (String)parsedArgs.get(FUNCTION);
                String[] moduleAndFunc = this.splitFunction(func);
                if (moduleAndFunc != null) {
                    try {
                        LOGGER.info("Invoking SCL function {}/{}", (Object)moduleAndFunc[0], (Object)moduleAndFunc[1]);
                        SCLContext.getCurrent().put((Object)"reportingHandler", (Object)SCLReportingHandler.DEFAULT);
                        Simantics.applySCL(moduleAndFunc[0], moduleAndFunc[1], Tuple0.INSTANCE);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Invocation failed", t);
                    }
                } else {
                    LOGGER.error("SCL function '{}' not invocable for baselining the database", (Object)func);
                }
            }
            Simantics.shutdown((IProgressMonitor)progress);
            Path actualOutput = DatabaseBaselines.packageBaseline(workspace, output);
            System.out.println("OK " + actualOutput.normalize().toAbsolutePath());
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception e) {
            LOGGER.error("Baseline creation failed.", (Throwable)e);
            throw e;
        }
        finally {
            System.exit(0);
        }
    }

    private String[] splitFunction(String func) {
        int l = func.lastIndexOf(47);
        if (l < 0) {
            return null;
        }
        return new String[]{func.substring(0, l), func.substring(l + 1)};
    }

    public void stop() {
    }
}

