/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.cheatsheets.actions.CheatSheetCategoryBasedSelectionAction;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.simantics.workbench.internal.Activator;

public class SimanticsWorkbenchActionBarAdvisor
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private boolean isDisposed = false;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    protected ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    protected ActionFactory.IWorkbenchAction quitAction;
    protected ActionFactory.IWorkbenchAction undoAction;
    protected ActionFactory.IWorkbenchAction redoAction;
    protected ActionFactory.IWorkbenchAction cutAction;
    protected ActionFactory.IWorkbenchAction copyAction;
    protected ActionFactory.IWorkbenchAction pasteAction;
    protected ActionFactory.IWorkbenchAction deleteAction;
    protected ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction newEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction openEditorDropDownAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction introAction;
    private ActionFactory.IWorkbenchAction tocAction;
    private ActionFactory.IWorkbenchAction searchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private IAction cheatSheetsAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    public static final ActionFactory OPEN_NEW_WINDOW = new ActionFactory("openNewWindow"){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NewWindowAction action = new NewWindowAction(window);
            action.setId(this.getId());
            return action;
        }
    };

    public SimanticsWorkbenchActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.closeAction = null;
        this.closeAllAction = null;
        this.closeAllSavedAction = null;
        this.closeOthersAction = null;
        this.openWorkspaceAction = null;
        this.importResourcesAction = null;
        this.exportResourcesAction = null;
        this.quitAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
        this.deleteAction = null;
        this.selectAllAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.newWindowAction = null;
        this.newEditorAction = null;
        this.openPreferencesAction = null;
        this.savePerspectiveAction = null;
        this.resetPerspectiveAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.closeAllPerspsAction = null;
        this.openPreferencesAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.maximizePartAction = null;
        this.minimizePartAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.activateEditorAction = null;
        this.switchToEditorAction = null;
        this.openEditorDropDownAction = null;
        this.introAction = null;
        this.tocAction = null;
        this.searchAction = null;
        this.dynamicHelpAction = null;
        this.cheatSheetsAction = null;
        this.aboutAction = null;
        super.dispose();
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(window);
        this.register((IAction)this.closeOthersAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(window);
        this.register((IAction)this.closeAllSavedAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register((IAction)this.openWorkspaceAction);
        this.importResourcesAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportResourcesAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(window);
        this.register((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(window);
        this.register((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(window);
        this.register((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(window);
        this.register((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.register((IAction)this.previousAction);
        this.newWindowAction = OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText("&New Window");
        this.register((IAction)this.newWindowAction);
        this.newEditorAction = ActionFactory.NEW_EDITOR.create(window);
        this.register((IAction)this.newEditorAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.savePerspectiveAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspsAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register((IAction)this.showPartPaneMenuAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.minimizePartAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register((IAction)this.activateEditorAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register((IAction)this.switchToEditorAction);
        this.openEditorDropDownAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register((IAction)this.openEditorDropDownAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        this.tocAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.tocAction);
        this.searchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.searchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.cheatSheetsAction = new CheatSheetCategoryBasedSelectionAction("&Cheat Sheets...");
        this.cheatSheetsAction.setId("org.eclipse.ui.help.cheatSheetsAction");
        this.register(this.cheatSheetsAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
    }

    protected void hackRemoveUnwantedNavigationActions() {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        String[] actionSetId = new String[]{"org.eclipse.ui.edit.text.actionSet.navigation", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.ui.NavigateActionSet"};
        HashSet<String> actionSetIds = new HashSet<String>();
        String[] stringArray = actionSetId;
        int n = actionSetId.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            actionSetIds.add(s);
            ++n2;
        }
        int i = 0;
        while (i < actionSets.length) {
            if (actionSetIds.contains(actionSets[i].getId())) {
                IExtension ext = actionSets[i].getConfigurationElement().getDeclaringExtension();
                reg.removeExtension(ext, new Object[]{actionSets[i]});
            }
            ++i;
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        this.hackRemoveUnwantedNavigationActions();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add((IContributionItem)this.createNavigateMenu());
        menuBar.add((IContributionItem)this.createProjectMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add(this.createWindowMenu());
        menuBar.add(this.createHelpMenu());
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
    }

    protected IContributionItem createFileMenu() {
        MenuManager menu = new MenuManager("&File", "sFile");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openWorkspaceAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        ActionContributionItem quitItem = new ActionContributionItem((IAction)this.quitAction);
        quitItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)quitItem);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    protected IContributionItem createEditMenu() {
        MenuManager menu = new MenuManager("&Edit", "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        return menu;
    }

    protected MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager("&Navigate", "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IContributionItem)new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("open.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator("show.ext"));
        i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("show.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.add((IContributionItem)new Separator());
        return menu;
    }

    protected MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager("&Project", "sProject");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("projEnd"));
        menu.add((IContributionItem)new Separator());
        return menu;
    }

    protected IContributionItem createWindowMenu() {
        MenuManager menu = new MenuManager("&Window", "window");
        menu.add((IAction)this.newWindowAction);
        menu.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        Separator sep = new Separator("additions");
        sep.setVisible(!Util.isMac());
        menu.add((IContributionItem)sep);
        sep = new Separator("additions.end");
        sep.setVisible(!Util.isMac());
        menu.add((IContributionItem)sep);
        ActionContributionItem openPreferencesItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        openPreferencesItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)openPreferencesItem);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    protected IContributionItem createHelpMenu() {
        MenuManager menu = new MenuManager("&Help", "help");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        if (this.introAction != null) {
            menu.add((IAction)this.introAction);
        }
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        menu.add((IContributionItem)new Separator("group.main"));
        menu.add((IAction)this.tocAction);
        menu.add((IAction)this.searchAction);
        menu.add((IAction)this.dynamicHelpAction);
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        menu.add((IContributionItem)new Separator("group.main"));
        this.addSeparatorOrGroupMarker(menu, "group.assist");
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        menu.add(this.cheatSheetsAction);
        this.addSeparatorOrGroupMarker(menu, "group.tutorials");
        this.addSeparatorOrGroupMarker(menu, "group.tools");
        this.addSeparatorOrGroupMarker(menu, "group.updates");
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
        aboutItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)aboutItem);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        MenuManager changePerspMenuMgr = new MenuManager("&Open Perspective", "openPerspective");
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager("Show &View", "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add((IAction)this.savePerspectiveAction);
        menu.add((IAction)this.resetPerspectiveAction);
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager("Navi&gation", "shortcuts");
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.maximizePartAction);
        subMenu.add((IAction)this.minimizePartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IAction)this.switchToEditorAction);
        subMenu.add((IAction)this.openEditorDropDownAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private void addSeparatorOrGroupMarker(MenuManager menu, String groupId) {
        String prefId = "useSeparator." + menu.getId() + "." + groupId;
        boolean addExtraSeparators = Activator.getDefault().getPreferenceStore().getBoolean(prefId);
        if (addExtraSeparators) {
            menu.add((IContributionItem)new Separator(groupId));
        } else {
            menu.add((IContributionItem)new GroupMarker(groupId));
        }
    }

    static class DelegateAdaptable
    implements IAdaptable {
        IAdaptable target;

        public DelegateAdaptable(IAdaptable target) {
            this.target = target;
        }

        public Object getAdapter(Class adapter) {
            return this.target != null ? this.target.getAdapter(adapter) : null;
        }
    }

    static class NewWindowAction
    extends OpenInNewWindowAction {
        private IWorkbenchWindow workbenchWindow;

        public NewWindowAction(IWorkbenchWindow window) {
            super(window);
            this.workbenchWindow = window;
        }

        public void dispose() {
            this.workbenchWindow = null;
            super.dispose();
        }

        public void run() {
            IAdaptable defaultInput = ((Workbench)this.workbenchWindow.getWorkbench()).getDefaultPageInput();
            this.setPageInput(new DelegateAdaptable(defaultInput));
            super.run();
        }
    }
}

