/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.search;

import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 */
public class QueryResult extends Tuple {

    public QueryResult(String html, int hits) {
        this("",html,"", hits);
    }
    
    public QueryResult(String header, String content, String footer, int hits) {
        super(header,content,footer, hits);
    }
    
    public String getHeader() {
        return (String) getField(0);
    }
    public String getContent() {
        return (String) getField(1);
    }
    
    public String getFooter() {
        return (String) getField(2);
    }

    public String getHtml() {
        return getHeader() + getContent() + getFooter();
    }

    public int getHitCount() {
        return (Integer) getField(3);
    }

}