package org.simantics.wiki.ui.editor;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.simantics.g2d.utils.FontHelper;

/**
 * @author Tuukka Lehtonen
 */
public final class WikiFontUtil {

    /**
     * ID for wiki source text font.
     */
    public static final String SOURCE_FONT_ID = "org.simantics.wiki.sourcefont";

    /**
     * @param resourceManager a resource manager for handling font allocations
     * @param control the control to attach the font to
     * @param fontRegistryId registry id of font to use for control
     */
    public static void attachControlFontToRegistry(
            final ResourceManager resourceManager,
            final Control control,
            String fontRegistryId)
    {
        final FontRegistry fontRegistry = FontHelper.getCurrentThemeFontRegistry();
        final IPropertyChangeListener fontRegistryListener = new IPropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent event) {
                FontData[] fdn = ((FontData[]) event.getNewValue());
                FontDescriptor fd = FontDescriptor.createFrom(fdn);
                control.setFont((Font) resourceManager.get(fd));
            }
        };
        fontRegistry.addListener(fontRegistryListener);
        FontDescriptor fd = fontRegistry.getDescriptor(fontRegistryId);
        control.setFont((Font) resourceManager.get(fd));
        control.addListener(SWT.Dispose, new Listener() {
            @Override
            public void handleEvent(Event event) {
                fontRegistry.removeListener(fontRegistryListener);
            }
        });
    }

}
