/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.ui.workbench.ResourceEditorPart2;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public abstract class ModelledEditor
extends ResourceEditorPart2 {
    public SWTRoot root;
    private Composite base;

    protected abstract String configurationURI();

    public void createPartControl(Composite parent) {
        try {
            final Variable variable = this.getResourceInput2().getVariable();
            Resource runtime = (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource resource = graph.newResource();
                    graph.claim(resource, L0.InstanceOf, null, SG.Runtime);
                    graph.claimLiteral(resource, SG.Runtime_HasVariable, (Object)variable.getURI((ReadGraph)graph), (Binding)Bindings.STRING);
                    return resource;
                }
            });
            this.base = new Composite(parent, 0);
            this.base.setLayout((Layout)new FillLayout());
            SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, null);
            final Variable editorVariable = loader.getVariable((RequestProcessor)this.getSession(), this.configurationURI(), runtime);
            final Function3 onLoaded = (Function3)this.getSession().syncRequest((Read)new Read<Function3<WriteGraph, Variable, Variable, Boolean>>(){

                public Function3<WriteGraph, Variable, Variable, Boolean> perform(ReadGraph graph) throws DatabaseException {
                    return (Function3)editorVariable.getPossiblePropertyValue(graph, "onLoaded");
                }
            });
            if (onLoaded != null) {
                Simantics.getSession().sync((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        onLoaded.apply((Object)graph, (Object)editorVariable, (Object)variable);
                    }
                });
            }
            this.root = (SWTRoot)loader.load((RequestProcessor)this.getSession(), editorVariable);
            this.root.createControls(this.base);
        }
        catch (ServiceNotFoundException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new ActiveSelectionProvider(){

            public void setSelection(ISelection selection) {
                super.setSelection(selection);
            }
        });
    }

    public void setFocus() {
        if (this.root != null && this.root.getControl() != null && !this.root.getControl().isDisposed()) {
            this.root.getControl().setFocus();
        } else if (!this.base.isDisposed()) {
            this.base.setFocus();
        }
    }
}

