/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.simantics.utils.bytes.BEInt;
import org.simantics.utils.strings.FileNameUtils;

public class ByteArrays {
    public static void move(byte[] src, byte[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public static byte[] mid(byte[] src, int pos, int len) {
        if (pos + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[len];
        System.arraycopy(src, pos, result, 0, len);
        return result;
    }

    public static void move(byte[] src, byte[] dest, int pos, int length) {
        System.arraycopy(src, 0, dest, pos, length);
    }

    public static byte[] merge(byte[] src, byte[] src2) {
        byte[] result = new byte[src.length + src2.length];
        System.arraycopy(src, 0, result, 0, src.length);
        System.arraycopy(src2, 0, result, src.length, src2.length);
        return result;
    }

    public static byte[] merge(byte[] src, byte[] src2, byte[] src3) {
        byte[] result = new byte[src.length + src2.length + src3.length];
        System.arraycopy(src, 0, result, 0, src.length);
        System.arraycopy(src2, 0, result, src.length, src2.length);
        System.arraycopy(src3, 0, result, src.length + src2.length, src3.length);
        return result;
    }

    public static byte[] merge(byte[] src, byte[] src2, byte[] src3, byte[] src4) {
        byte[] result = new byte[src.length + src2.length + src3.length + src4.length];
        System.arraycopy(src, 0, result, 0, src.length);
        System.arraycopy(src2, 0, result, src.length, src2.length);
        System.arraycopy(src3, 0, result, src.length + src2.length, src3.length);
        System.arraycopy(src4, 0, result, src.length + src2.length + src3.length, src4.length);
        return result;
    }

    public static byte[] merge(byte[] src, byte[] src2, byte[] src3, byte[] src4, byte[] src5) {
        byte[] result = new byte[src.length + src2.length + src3.length + src4.length + src5.length];
        System.arraycopy(src, 0, result, 0, src.length);
        System.arraycopy(src2, 0, result, src.length, src2.length);
        System.arraycopy(src3, 0, result, src.length + src2.length, src3.length);
        System.arraycopy(src4, 0, result, src.length + src2.length + src3.length, src4.length);
        System.arraycopy(src5, 0, result, src.length + src2.length + src3.length + src4.length, src5.length);
        return result;
    }

    public static int swap(int i) {
        int byte0 = i & 0xFF;
        int byte1 = i >> 8 & 0xFF;
        int byte2 = i >> 16 & 0xFF;
        int byte3 = i >> 24 & 0xFF;
        return byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
    }

    public static void saveToFile(byte[] data, String filename) throws IOException {
        String dir = FileNameUtils.extractFileDir(filename);
        new File(dir).mkdirs();
        FileOutputStream out = new FileOutputStream(filename);
        out.write(data);
        out.flush();
        out.close();
    }

    public static void main(String[] args) {
        byte[] array1 = BEInt.toBytes(5);
        byte[] array2 = BEInt.toBytes(10);
        byte[] array = ByteArrays.merge(array1, array2);
        ByteArrays.printByteArray(array);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

