/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.internal.Activator;

public class ListDialog<T>
extends Dialog {
    private static final String DIALOG = "ListDialog";
    private final Collection<T> selectables;
    private final String title;
    private final String description;
    private StructuredViewer viewer;
    private IDialogSettings dialogBoundsSettings;
    private final ViewerSorter sorter = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)ListDialog.this.toLabel(e1), (Object)ListDialog.this.toLabel(e2));
        }
    };

    public ListDialog(Shell parent, Collection<T> selectables, String title, String description) {
        super(parent);
        this.selectables = selectables;
        this.title = title;
        this.description = description;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        if (this.title != null) {
            newShell.setText(this.title);
        } else {
            newShell.setText("Select");
        }
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(500, 300);
        }
        return result;
    }

    protected StructuredViewer createViewer(Composite composite) {
        return new TableViewer(composite, 68356);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.description != null) {
            Label label = new Label(composite, 0);
            label.setText(this.description);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.viewer = this.createViewer(composite);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SelectableLabelProvider());
        this.viewer.setSorter(this.sorter);
        this.viewer.setInput(this.selectables);
        ListDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private String toLabel(T t) {
        return t.toString();
    }

    class SelectableLabelProvider
    extends LabelProvider {
        SelectableLabelProvider() {
        }

        public String getText(Object element) {
            return ListDialog.this.toLabel(element);
        }
    }
}

