/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorDialog;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorGradientAdjustingCanvas;
import org.simantics.utils.ui.color.ColorValue;
import org.simantics.utils.ui.color.ColorValueComparator;

public class ColorGradientComposite2
extends Composite
implements ISelectionChangedListener {
    private ColorGradientAdjustingCanvas gradientComposite;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button rgbButton;
    private Button hsvButton;
    private int type = 0;
    private ArrayList<ColorValue> values = new ArrayList();

    public ColorGradientComposite2(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        this.gradientComposite = new ColorGradientAdjustingCanvas(this, 256);
        this.gradientComposite.addSelectionChangedListener(this);
        Composite typeComposite = new Composite((Composite)this, 0);
        typeComposite.setLayout((Layout)new GridLayout(1, false));
        this.rgbButton = new Button(typeComposite, 16);
        this.rgbButton.setSelection(true);
        this.rgbButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColorGradientComposite2.this.rgbButton.setSelection(true);
                ColorGradientComposite2.this.hsvButton.setSelection(false);
                ColorGradientComposite2.this.type = 0;
                ColorGradientComposite2.this.gradientComposite.setGradient(new ColorGradient(ColorGradientComposite2.this.values, ColorGradientComposite2.this.type));
            }
        });
        this.rgbButton.setText("RGB");
        this.hsvButton = new Button(typeComposite, 16);
        this.hsvButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColorGradientComposite2.this.hsvButton.setSelection(true);
                ColorGradientComposite2.this.rgbButton.setSelection(false);
                ColorGradientComposite2.this.type = 1;
                ColorGradientComposite2.this.gradientComposite.setGradient(new ColorGradient(ColorGradientComposite2.this.values, ColorGradientComposite2.this.type));
            }
        });
        this.hsvButton.setText("HSV");
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)new FillLayout(256));
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText("Add new color");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGB rgb = ColorGradientComposite2.this.openDialog(null);
                if (rgb != null) {
                    Double value;
                    Color c = new Color(rgb.red, rgb.green, rgb.blue);
                    if (ColorGradientComposite2.this.values.size() == 0) {
                        value = 0.0;
                    } else if (ColorGradientComposite2.this.values.size() == 1) {
                        value = 100.0;
                    } else {
                        StructuredSelection selection = (StructuredSelection)ColorGradientComposite2.this.gradientComposite.getSelection();
                        if (selection.size() == 1) {
                            ColorValue v = (ColorValue)selection.getFirstElement();
                            int index = ColorGradientComposite2.this.values.indexOf(v);
                            if (index == ColorGradientComposite2.this.values.size() - 1) {
                                --index;
                            }
                            value = (((ColorValue)ColorGradientComposite2.this.values.get(index + 1)).getValue() - ((ColorValue)ColorGradientComposite2.this.values.get(index)).getValue()) * 0.5;
                            value = value + ((ColorValue)ColorGradientComposite2.this.values.get(index)).getValue();
                        } else {
                            int index = 0;
                            double r = 0.0;
                            int i = 0;
                            while (i < ColorGradientComposite2.this.values.size() - 1) {
                                double v1 = ((ColorValue)ColorGradientComposite2.this.values.get(i)).getValue();
                                double v2 = ((ColorValue)ColorGradientComposite2.this.values.get(i + 1)).getValue();
                                double vr = v2 - v1;
                                if (vr > r) {
                                    r = vr;
                                    index = i;
                                }
                                ++i;
                            }
                            value = ((ColorValue)ColorGradientComposite2.this.values.get(index)).getValue() + r * 0.5;
                        }
                    }
                    ColorGradientComposite2.this.addColor(c, value);
                }
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText("Edit color");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGB rgb;
                Object obj = ((StructuredSelection)ColorGradientComposite2.this.gradientComposite.getSelection()).getFirstElement();
                if (obj == null) {
                    return;
                }
                if (obj instanceof ColorValue && (rgb = ColorGradientComposite2.this.openDialog(((ColorValue)obj).getColor().getRgb())) != null) {
                    ColorGradientComposite2.this.modifyColorValueColor((ColorValue)obj, rgb);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText("Remove color");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = ((StructuredSelection)ColorGradientComposite2.this.gradientComposite.getSelection()).getFirstElement();
                if (o == null) {
                    return;
                }
                if (o instanceof ColorValue) {
                    ColorGradientComposite2.this.values.remove(o);
                    ColorGradientComposite2.this.updateWidgets();
                }
            }
        });
        this.removeButton.setEnabled(false);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).align(4, 0x1000000).hint(-1, 32).applyTo((Control)this.gradientComposite);
        GridDataFactory.fillDefaults().grab(false, true).align(16384, 4).applyTo((Control)typeComposite);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).align(4, 128).applyTo((Control)buttonComposite);
    }

    protected RGB openDialog(RGB selection) {
        Color color;
        ColorDialog dialog = new ColorDialog(this.getShell());
        if (selection != null) {
            color = new Color(selection);
            dialog.setInitialValue(color);
        }
        if (dialog.open() == 0) {
            color = dialog.getColor();
            return color.getRgb();
        }
        return null;
    }

    public void addColor(Color color, double value) {
        this.addColor(new ColorValue(color, value));
    }

    public void addColor(ColorValue value) {
        this.values.add(value);
        this.updateWidgets();
    }

    private void updateWidgets() {
        Collections.sort(this.values, new ColorValueComparator());
        this.gradientComposite.setGradient(new ColorGradient(this.values, this.type));
    }

    public ColorGradient getGradient() {
        return new ColorGradient(this.values, this.type);
    }

    public void dispose() {
        super.dispose();
    }

    public void setGradient(ColorGradient gradient) {
        this.values.clear();
        this.type = gradient.getType();
        for (ColorValue value : gradient.getColorValues()) {
            this.addColor(value);
        }
        if (this.type == 1) {
            this.rgbButton.setSelection(false);
            this.hsvButton.setSelection(true);
        } else if (this.type == 0) {
            this.hsvButton.setSelection(false);
            this.rgbButton.setSelection(true);
        }
    }

    private void modifyColorValueColor(ColorValue cValue, RGB rgb) {
        this.values.remove(cValue);
        Color newColor = new Color(rgb.red, rgb.green, rgb.blue);
        ColorValue newCValue = new ColorValue(newColor, cValue.getValue());
        this.values.add(newCValue);
        this.updateWidgets();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (obj == null) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            int index = this.values.indexOf(obj);
            if (index > 0 && index < this.values.size() - 1) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }
}

