/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorGradientCanvas;
import org.simantics.utils.ui.color.ColorIconCreator;
import org.simantics.utils.ui.color.ColorValue;
import org.simantics.utils.ui.color.ColorValueComparator;

public class ColorGradientComposite
extends Composite
implements ISelectionChangedListener,
ICellEditorListener,
IPropertyChangeListener {
    private static int ICON_WIDTH = 36;
    private static int ICON_HEIGHT = 14;
    private static final String COLOR_ID = "Color";
    private static final String VALUE_ID = "Value";
    private ColorGradientCanvas gradientComposite;
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button rgbButton;
    private Button hsvButton;
    private int type = 0;
    private ArrayList<ColorValue> values = new ArrayList();
    private HashMap<ColorValue, Image> images = new HashMap();

    public ColorGradientComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        this.gradientComposite = new ColorGradientCanvas(this, 256);
        Composite typeComposite = new Composite((Composite)this, 0);
        typeComposite.setLayout((Layout)new GridLayout(1, false));
        this.rgbButton = new Button(typeComposite, 16);
        this.rgbButton.setSelection(true);
        this.rgbButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColorGradientComposite.this.rgbButton.setSelection(true);
                ColorGradientComposite.this.hsvButton.setSelection(false);
                ColorGradientComposite.this.type = 0;
                ColorGradientComposite.this.gradientComposite.setGradient(new ColorGradient(ColorGradientComposite.this.values, ColorGradientComposite.this.type));
            }
        });
        this.rgbButton.setText("RGB");
        this.hsvButton = new Button(typeComposite, 16);
        this.hsvButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColorGradientComposite.this.hsvButton.setSelection(true);
                ColorGradientComposite.this.rgbButton.setSelection(false);
                ColorGradientComposite.this.type = 1;
                ColorGradientComposite.this.gradientComposite.setGradient(new ColorGradient(ColorGradientComposite.this.values, ColorGradientComposite.this.type));
            }
        });
        this.hsvButton.setText("HSV");
        this.viewer = new TableViewer((Composite)this, 67588);
        final Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
        TableColumn column = new TableColumn(table, 131072);
        column.setText(COLOR_ID);
        column.setWidth(60);
        column.setMoveable(false);
        column.setResizable(false);
        column = new TableColumn(table, 16384);
        column.setText(VALUE_ID);
        column.setWidth(300);
        column.setMoveable(false);
        this.viewer.setColumnProperties(new String[]{COLOR_ID, VALUE_ID});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setInput(this.values);
        ColorCellEditor colorEditor = new ColorCellEditor((Composite)table);
        TextCellEditor valueEditor = new TextCellEditor((Composite)table);
        colorEditor.addListener((ICellEditorListener)this);
        valueEditor.addListener((ICellEditorListener)this);
        valueEditor.addPropertyChangeListener((IPropertyChangeListener)this);
        this.viewer.setCellEditors(new CellEditor[]{colorEditor, valueEditor});
        this.viewer.setCellModifier((ICellModifier)new TableCellEditorModifier());
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)new FillLayout(512));
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText("Add new color");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(ColorGradientComposite.this.getShell(), 0);
                RGB rgb = dialog.open();
                if (rgb != null) {
                    Double value;
                    Color c = new Color(rgb.red, rgb.green, rgb.blue);
                    if (ColorGradientComposite.this.values.size() == 0) {
                        value = 0.0;
                    } else if (ColorGradientComposite.this.values.size() == 1) {
                        value = 100.0;
                    } else {
                        StructuredSelection selection = (StructuredSelection)ColorGradientComposite.this.viewer.getSelection();
                        if (selection.size() == 1) {
                            ColorValue v = (ColorValue)selection.getFirstElement();
                            int index = ColorGradientComposite.this.values.indexOf(v);
                            if (index == ColorGradientComposite.this.values.size() - 1) {
                                --index;
                            }
                            value = (((ColorValue)ColorGradientComposite.this.values.get(index + 1)).getValue() - ((ColorValue)ColorGradientComposite.this.values.get(index)).getValue()) * 0.5;
                            value = value + ((ColorValue)ColorGradientComposite.this.values.get(index)).getValue();
                        } else {
                            int index = 0;
                            double r = 0.0;
                            int i = 0;
                            while (i < ColorGradientComposite.this.values.size() - 1) {
                                double v1 = ((ColorValue)ColorGradientComposite.this.values.get(i)).getValue();
                                double v2 = ((ColorValue)ColorGradientComposite.this.values.get(i + 1)).getValue();
                                double vr = v2 - v1;
                                if (vr > r) {
                                    r = vr;
                                    index = i;
                                }
                                ++i;
                            }
                            value = ((ColorValue)ColorGradientComposite.this.values.get(index)).getValue() + r * 0.5;
                        }
                    }
                    ColorGradientComposite.this.addColor(c, value);
                }
            }
        });
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText("Edit color");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected;
                Object obj;
                TableItem[] selection = table.getSelection();
                if (selection.length > 0 && (obj = (selected = selection[0]).getData()) instanceof ColorValue) {
                    ColorDialog dialog = new ColorDialog(ColorGradientComposite.this.getShell(), 0);
                    dialog.setRGB(ColorGradientComposite.this.getRGB(((ColorValue)obj).getColor()));
                    RGB rgb = dialog.open();
                    if (rgb != null) {
                        ColorGradientComposite.this.modifyColorValueColor((ColorValue)obj, rgb);
                    }
                }
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText("Remove color");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected;
                Object o;
                TableItem[] selection = table.getSelection();
                if (selection.length > 0 && (o = (selected = selection[0]).getData()) instanceof ColorValue) {
                    Image i = (Image)ColorGradientComposite.this.images.get(o);
                    i.dispose();
                    ColorGradientComposite.this.images.remove(o);
                    ColorGradientComposite.this.values.remove(o);
                    ColorGradientComposite.this.updateWidgets();
                }
            }
        });
        this.removeButton.setEnabled(false);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).align(4, 0x1000000).hint(-1, 32).applyTo((Control)this.gradientComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(-1, 100).applyTo((Control)table);
        GridDataFactory.fillDefaults().grab(false, true).align(16384, 4).applyTo((Control)typeComposite);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).align(4, 128).applyTo((Control)buttonComposite);
    }

    public void addColor(Color color, double value) {
        this.addColor(new ColorValue(color, value));
    }

    public void addColor(ColorValue value) {
        this.values.add(value);
        Image image = ColorIconCreator.createImage(value.getColor(), ICON_WIDTH, ICON_HEIGHT, 2048);
        this.images.put(value, image);
        this.updateWidgets();
    }

    private void updateWidgets() {
        Collections.sort(this.values, new ColorValueComparator());
        this.gradientComposite.setGradient(new ColorGradient(this.values, this.type));
        this.viewer.refresh();
    }

    public ColorGradient getGradient() {
        return new ColorGradient(this.values, this.type);
    }

    public void dispose() {
        for (Image i : this.images.values()) {
            i.dispose();
        }
        super.dispose();
    }

    public void setGradient(ColorGradient gradient) {
        for (Image i : this.images.values()) {
            i.dispose();
        }
        this.values.clear();
        this.images.clear();
        this.type = gradient.getType();
        for (ColorValue value : gradient.getColorValues()) {
            this.addColor(value);
        }
        if (this.type == 1) {
            this.rgbButton.setSelection(false);
            this.hsvButton.setSelection(true);
        } else if (this.type == 0) {
            this.hsvButton.setSelection(false);
            this.rgbButton.setSelection(true);
        }
    }

    private RGB getRGB(Color color) {
        RGB rgb = new RGB(color.getR(), color.getG(), color.getB());
        return rgb;
    }

    private void modifyColorValueValue(ColorValue cValue, String string) {
        try {
            double d = Double.parseDouble(string);
            this.values.remove(cValue);
            Image image = this.images.get(cValue);
            this.images.remove(cValue);
            ColorValue newCValue = new ColorValue(cValue.getColor(), d);
            this.values.add(newCValue);
            this.images.put(newCValue, image);
            this.updateWidgets();
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void modifyColorValueColor(ColorValue cValue, RGB rgb) {
        this.values.remove(cValue);
        Image oldImage = this.images.get(cValue);
        oldImage.dispose();
        this.images.remove(cValue);
        Color newColor = new Color(rgb.red, rgb.green, rgb.blue);
        ColorValue newCValue = new ColorValue(newColor, cValue.getValue());
        this.values.add(newCValue);
        Image newImage = ColorIconCreator.createImage(newColor, ICON_WIDTH, ICON_HEIGHT, 2048);
        this.images.put(newCValue, newImage);
        this.updateWidgets();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (obj == null) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    public void applyEditorValue() {
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void cancelEditor() {
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private class TableCellEditorModifier
    implements ICellModifier {
        private TableCellEditorModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property == ColorGradientComposite.VALUE_ID;
        }

        public Object getValue(Object element, String property) {
            if (property == ColorGradientComposite.VALUE_ID) {
                return Double.toString(((ColorValue)element).getValue());
            }
            if (property == ColorGradientComposite.COLOR_ID) {
                return ColorGradientComposite.this.getRGB(((ColorValue)element).getColor());
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            Object obj = item.getData();
            if (property == ColorGradientComposite.VALUE_ID) {
                ColorGradientComposite.this.modifyColorValueValue((ColorValue)obj, (String)value);
            }
            if (property == ColorGradientComposite.COLOR_ID) {
                ColorGradientComposite.this.modifyColorValueColor((ColorValue)obj, (RGB)value);
            }
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] valueArray = new ColorValue[ColorGradientComposite.this.values.size()];
            int i = 0;
            while (i < ColorGradientComposite.this.values.size()) {
                valueArray[i] = (ColorValue)ColorGradientComposite.this.values.get(ColorGradientComposite.this.values.size() - 1 - i);
                ++i;
            }
            return valueArray;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    implements ITableLabelProvider {
        private ArrayList<ILabelProviderListener> listeners = new ArrayList();

        private TableLabelProvider() {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ColorValue value = (ColorValue)element;
            if (columnIndex == 0) {
                return (Image)ColorGradientComposite.this.images.get(value);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ColorValue value = (ColorValue)element;
            if (columnIndex == 1) {
                return Double.toString(value.getValue());
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove(listener);
        }
    }
}

