/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Regular expression validator
 * 
 * @author Toni Kalajainen
 */
public class RegexpValidator implements IInputValidator {

    // Hostname mask
    //^([a-zA-Z0-9\\*]([a-zA-Z0-9\\-\\*]{0,61}[a-zA-Z0-9\\*])?\\.)*[a-zA-Z0-9\\*]([a-zA-Z0-9\\-\\*]{0,61}[a-zA-Z0-9\\*])?$
    
    // Untested
    //public static final String URL_VALIDATOR_STRING = "^[A-Za-z]+://[A-Za-z0-9-_]+\\.[A-Za-z0-9-_%&\\?\\/.=]+$";
    //public static RegexpValidator URL_VALIDATOR = new RegexpValidator(URL_VALIDATOR_STRING, "Invalid URL");
    
    private final Pattern pattern;
    private final String errorMsg;
    
    public RegexpValidator(String regexp, String errorMsg) {
        pattern = Pattern.compile(regexp);
        this.errorMsg = errorMsg;
    }
    
    public RegexpValidator(Pattern pattern, String errorMsg) {
        this.pattern = pattern;
        this.errorMsg = errorMsg;
    }

    public String isValid(String newText) {
        Matcher m = pattern.matcher(newText);
        if (m.matches()) return null;
        return errorMsg;
    }

}
