/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 28.6.2006
 */
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * RangeValidator is a validator that validates integer numbers
 * in a given range.
 * @author Toni Kalajainen
 */
public class RangeValidator implements IInputValidator {

    final long minValue;
    final long maxValue;

    public RangeValidator(long minValue, long maxValue)
    {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public String isValid(String newText) {
        try {
            long value = new Long(newText);
            if (value<minValue)
                return "Value must be at least or over "+minValue;
            if (value>maxValue)
                return "Value must be at most "+maxValue;
            return null;
        } catch (NumberFormatException e) {
            return "\""+newText+"\" is not an integer value";//;e.getMessage();
        }
    };

}
