/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * validates all long
 * 
 * @author Toni Kalajainen
 */
public class LongValidator implements IInputValidator {

    public static LongValidator LONG_VALIDATOR = new LongValidator();
    
    public String isValid(String newText) {
        try {
            new Long(newText);
            return null;
        } catch (NumberFormatException e) {
            return "\""+newText+"\" is not a long integer value";//;e.getMessage();
        }       
    }
}

