/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 9.10.2006
 */
package org.simantics.utils.ui.gfx.rasterize;

import org.eclipse.swt.graphics.ImageData;

/**
 * IRasterizable
 * @author Toni Kalajainen
 */
public interface IRasterizable {

    /**
     * Rasterize this image into a buffer. Buffer size must be atleast width*height*4.
     * 
     * @param width width
     * @param height height
     * @return SWT ImageData description filled with rasterization
     * @throws Exception on rasterize problems
     */
    ImageData rasterize(int width, int height)
    throws Exception;
    
}
