/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx.clipboard.streams;

import java.io.IOException;
import java.io.OutputStream;

import org.simantics.utils.ui.gfx.clipboard.headers.BitmapFileHeader;


/**
 * Removes WIN32 API BITMAPFILEHEADER from the beginning of stream
 * 
 * @author Marko Luukkainen
 *
 */
public class RemoveBitmapHeaderOutputStream extends OutputStream{
    private OutputStream oStream;
    private int byteCount = 0;
    
    public RemoveBitmapHeaderOutputStream(OutputStream oStream) {
        this.oStream = oStream;
    }
    
    @Override
    public void write(byte[] b) throws IOException {
        if (byteCount >= BitmapFileHeader.sizeof) {
            super.write(b);
        } else if (b.length >= BitmapFileHeader.sizeof - byteCount){
            byte[] newArray = new byte[b.length - BitmapFileHeader.sizeof + byteCount];
            System.arraycopy(b, BitmapFileHeader.sizeof - byteCount, newArray, 0, newArray.length);
            byteCount = BitmapFileHeader.sizeof;
            super.write(newArray);    
        } else {
            byteCount+= b.length;
        }
        super.write(b);
    }
    
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (byteCount >= BitmapFileHeader.sizeof)
            super.write(b, off, len);
        else
            throw new IOException("Operation not supported, cannot remove header"); 
    }
    
    @Override
    public void write(int b) throws IOException {
        if (byteCount >= BitmapFileHeader.sizeof) {
            oStream.write(b);
        } else {
            byteCount++;
        }
    }
}
