/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

/**
 * Colored rectangle with black borders.
 *  
 * @author toni.kalajainen
 */
public class ColorImageDescriptor extends ImageDescriptor {
    static final PaletteData PALETTEDATA = new PaletteData(0x00ff0000, 0x0000ff00, 0x000000ff);

	int width;
	int height;
	int c;
	boolean selected;
	
	public ColorImageDescriptor(int red, int green, int blue, int width, int height, boolean selected)
	{
        c = (red<<16) | (green<<8) | (blue);
		this.width = width;
		this.height = height;
		this.selected = selected;
	}

	@Override
	public ImageData getImageData(int zoom) {
		int w = width;
		int h = height;
		if (zoom > 100) {
			float s = zoom / 100.0f;
			w = Math.round(width * s);
			h = Math.round(height * s);
		}
		return getImageData(w, h);
	}

	@Override
	public ImageData getImageData() {
		return getImageData(100);
	}

	private ImageData getImageData(int width, int height) {
		ImageData id = new ImageData(width, height, 24, PALETTEDATA);
		int cx = width / 2;
		int cy = height / 2;
		int dst = height * width / 23;
		for (int x=0; x<width; x++) {
			for (int y=0; y<height; y++) {
				int color = c;
				boolean border = x==0||x==width-1||y==0||y==height-1;
				if ( border ) color = 0;
				if (selected) {
					int dist = (x-cx)*(x-cx)+(y-cy)*(y-cy);
					if ( dist < dst ) color = 0xcccccc; 
				}
				id.setPixel(x, y, color);
			}
		}

		return id;
	}

	@Override
	public int hashCode() {
		return c + 7*width + 13*height + (selected?234234:4235);
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj instanceof ColorImageDescriptor == false ) return false;
		ColorImageDescriptor other = (ColorImageDescriptor) obj;
		if ( other.width!=width ) return false;
		if ( other.height!=height ) return false;
		if ( other.c!=c ) return false;
		if ( other.selected!=selected ) return false;
		return true;
	}
	
}
