/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 22.12.2006
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;

/**
 * AlphaAdjustmentImageDescriptor multiplies alpha by (adjustment value/256)
 * <p>
 * Usage:
 * ImageDescriptor icon;
 * icon = AlphaAdjustmentImageDescriptor.adjustAlpha(icon, 128);
 * 
 * @author Toni Kalajainen
 */
public class AlphaAdjustmentImageDescriptor extends ImageDescriptor {
    
    public static ImageDescriptor adjustAlpha(ImageDescriptor desc, int alphaAdjustment)
    {
        if (alphaAdjustment==256) return desc;
        return new AlphaAdjustmentImageDescriptor(desc, alphaAdjustment);
    }
    
    int alphaAdjustment;
    ImageDescriptor desc;
    
    /**
     * 
     * @param original
     * @param alphaAdjustment 0..256
     */
    public AlphaAdjustmentImageDescriptor(ImageDescriptor original, int alphaAdjustment)
    {
        assert(alphaAdjustment>=0 && alphaAdjustment<=256);
        assert(original!=null);
        this.alphaAdjustment = alphaAdjustment;
        this.desc = original;
    }

    @SuppressWarnings("deprecation")
    @Override
    public ImageData getImageData() {
        ImageData orig = ImageCache.getInstance().getImage(desc).getImageData();
        ImageData id = new ImageData(orig.width, orig.height, orig.depth, orig.palette);
        id.setAlpha(0,0,0);
        
        if (orig.getTransparencyType()==SWT.TRANSPARENCY_ALPHA ||
            orig.getTransparencyType()==SWT.TRANSPARENCY_NONE)
        {
            for (int x=0; x<orig.width; x++)
                for (int y=0; y<orig.height; y++) {
                    id.setPixel(x, y, orig.getPixel(x, y));
                    int alpha = (orig.getAlpha(x, y) * alphaAdjustment) >> 8;
                    id.setAlpha(x, y, alpha);
                }
        } else
        if (orig.getTransparencyType()==SWT.TRANSPARENCY_MASK ||
            orig.getTransparencyType()==SWT.TRANSPARENCY_PIXEL) {
            ImageData mask = orig.getTransparencyMask();
            for (int x=0; x<orig.width; x++)
                for (int y=0; y<orig.height; y++) {
                    id.setPixel(x, y, orig.getPixel(x, y));
                    int alpha = (mask.getPixel(x, y)==1?alphaAdjustment:0);
                    id.setAlpha(x, y, alpha);
                }
        }
        
        return id;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AlphaAdjustmentImageDescriptor))
            return false;
        AlphaAdjustmentImageDescriptor other = (AlphaAdjustmentImageDescriptor) obj;
        if (!other.desc.equals(desc))
            return false;
        if (other.alphaAdjustment!=alphaAdjustment)
            return false;
        return true;
    }
    
    @Override
    public int hashCode() {
        return desc.hashCode() ^ 0x58fb2 ^ alphaAdjustment;
    }

}
